package com.liquidnet.service.galaxy.dto.param;

import com.liquidnet.commons.lang.util.JsonUtils;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: GalaxyQueryNftTradeListReqDto
 * @Package com.liquidnet.service.galaxy.dto.param
 * @Copyright: LightNet @ Copyright (c) 2022
 * @date 2022/4/8 16:27
 */
@ApiModel(value = "GalaxyQueryNftTradeListReqDto", description = "单个NFT交易信息查询")
@Data
public class GalaxyQueryNftTradeListReqDto extends GalaxyBaseReqDto implements Serializable,Cloneable{
    @ApiModelProperty(position = 1, required = true, value = "skuId")
    private String skuId;

    @Override
    public String toString(){
        return JsonUtils.toJson(this);
    }

    private static final GalaxyQueryNftTradeListReqDto obj = new GalaxyQueryNftTradeListReqDto();

    public static GalaxyQueryNftTradeListReqDto getNew() {
        try {
            return (GalaxyQueryNftTradeListReqDto) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GalaxyQueryNftTradeListReqDto();
        }
    }
}
