package com.liquidnet.service.galaxy.dto.param;

import com.liquidnet.commons.lang.util.JsonUtils;
import io.swagger.annotations.ApiModel;
import lombok.Data;

import java.io.Serializable;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: GalaxyQuerySeriesInfoRespDto
 * @Package com.liquidnet.service.galaxy.dto.param
 * @Copyright: LightNet @ Copyright (c) 2022
 * @date 2022/4/7 16:27
 */
@ApiModel(value = "GalaxyQuerySeriesInfoRespDto", description = "系列查询")
@Data
public class GalaxyQuerySeriesInfoRespDto implements Serializable,Cloneable {
    /**
     * 系列ID
     */
    private String seriesId;
    /**
     * 系列名字
     */
    private String name;
    /**
     * 创建者地址
     */
    private String creatorAddr;
    /**
     * 总数
     */
    private String totalCount;
    /**
     * 系列下的nftId后缀,是否从0开始，true就是从0开始，默认为false，从1开始
     */
    private String seriesBeginFromZero;
    /**
     * 当前个数（当前已发行此系列的个数）
     */
    private String crtCount;
    /**
     * 封面图
     */
    private String coverUrl;
    /**
     * 描述
     */
    private String desc;
    /**
     * 创建时间戳
     */
    private String createTimeStamp;
    @Override
    public String toString(){
        return JsonUtils.toJson(this);
    }

    private static final GalaxyQuerySeriesInfoRespDto obj = new GalaxyQuerySeriesInfoRespDto();

    public static GalaxyQuerySeriesInfoRespDto getNew() {
        try {
            return (GalaxyQuerySeriesInfoRespDto) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GalaxyQuerySeriesInfoRespDto();
        }
    }
}