package com.liquidnet.service.goblin.service.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import com.liquidnet.commons.lang.util.CollectionUtil;
import com.liquidnet.commons.lang.util.HttpUtil;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.service.adam.dto.vo.AdamUserBizAcctVo;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.goblin.util.GoblinRedisUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;

@Service
@Slf4j
public class GoblinNftNumAccountServiceImpl {

    @Autowired
    private GoblinRedisUtils goblinRedisUtils;

    @Value("${liquidnet.service.adam.url}")
    private String adamUrl;

    public Boolean syncNotice(String userId) {
        // 请求adam
        MultiValueMap<String, String> headers = CollectionUtil.linkedMultiValueMapStringString();
        headers.add("Accept", MediaType.APPLICATION_JSON_UTF8_VALUE);
        headers.set("Content-Type", MediaType.APPLICATION_FORM_URLENCODED_VALUE);
        String returnData = HttpUtil.getByUri(adamUrl.concat("/adam/rsc/inquire/bizacc?bizCode=NFT_ZX&uid=".concat(userId)), headers);
        ResponseDto<AdamUserBizAcctVo> rsp = JsonUtils.fromJson(returnData, new TypeReference<ResponseDto<AdamUserBizAcctVo>>() {
        });
        AdamUserBizAcctVo rspData = rsp.getData();
        if (null != rspData) {
            // 写入redis
            goblinRedisUtils.setNftNumAccount(userId);
            return true;
        } else {
            log.info("同步数字账号失败,信息不存在 [userId:{}]", userId);
            return false;
        }
    }

}
