package com.liquidnet.common.cache.redis.util;

import com.liquidnet.common.cache.redis.config.AbstractRedisConfig;
import com.liquidnet.common.cache.redis.config.RedisGalaxyConfig;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @author AnJiabin <jiabin.an@lightnet.io>
 * @version V1.0
 * @Description: Redis工具类
 * @class: RedisUtil
 * @Package com.liquidnet.stellar.utils
 * @Copyright: LightNet @ Copyright (c) 2020
 * @date 2022/3/15 13:11
 */
@Slf4j
@Component("redisGalaxyUtil")
public final class RedisGalaxyUtil extends AbstractRedisUtil{
    @Autowired
    private RedisGalaxyConfig redisConfig;

    @Override
    public int getDbs() {
        log.info("RedisGalaxyUtil.totalDbs===",redisConfig.totalDbs);
        return redisConfig.totalDbs;
    }

    @Override
    AbstractRedisConfig getRedisConfig() {
        return this.redisConfig;
    }
}
