package com.liquidnet.service.dragon.controller;

import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.commons.lang.util.StringUtil;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.dragon.dto.DragonPayBaseReqDto;
import com.liquidnet.service.dragon.dto.DragonPayBaseRespDto;
import com.liquidnet.service.dragon.service.IDragonOrdersService;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: PayNotifyController
 * @Package com.liquidnet.service.dragon.controller
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2021/7/11 23:35
 */
@RestController
@RequestMapping("notify")
public class PayNotifyController {
    @Autowired
    private IDragonOrdersService dragonOrdersService;
    /**
     * 支付宝支付回调
     * @return
     */
    @PostMapping("/{payType}/{deviceFrom}")
    @ApiOperation("支付宝支付回调")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "payType", value = "支付类型:alipay,wepay,iappay", example = "alipay")
    })
    public String dragonNotify(@PathVariable("payType") String payType,@PathVariable("deviceFrom") String deviceFrom,HttpServletRequest request, HttpServletResponse respone) throws Exception {
        return dragonOrdersService.dragonNotify(request,payType,deviceFrom);
    }
    /**
     * 苹果内购
     */
    @PostMapping("/apple/purchase")
    @ApiOperation("苹果内购回调")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "payType", value = "支付类型:alipay,wepay,unionpay,applepay", example = "unionpay"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "deviceFrom", value = "设备来源:web,wap,app,js,apple,micropay,inner", example = "wap"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "type", value = "业务类型:TICKET,PRODUCT,COST,MBEANS,LIVE,VIDEO,VIP,CLUB,STRAWBERRY", example = "TICKET"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "price", value = "支付金额", example = "0.1"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "name", value = "订单名称", example = "测试订单001"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "detail", value = "订单描述", example = "测试订单001"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "orderId", value = "订单id", example = "orderId"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "orderCode", value = "订单编号", example = "ORDER0001"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "clientIp", value = "客户端ip", example = "127.0.0.1"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "notifyUrl", value = "通知url", example = "devdragon.zhengzai.tv"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "createDate", value = "订单创建时间", example = "2021-11-10 13:00:00"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "expireTime", value = "订单过期时间", example = "1000"),
            @ApiImplicitParam(type = "form", required = false, dataType = "String", name = "authCode", value = "付款码", example = "1000"),
    })
    public ResponseDto<DragonPayBaseRespDto> dragonNotifyApple(
            @RequestParam(value = "payType") @NotNull(message = "支付类型不能为空") String payType,
            @RequestParam(value = "deviceFrom") @NotNull(message = "设备来源不能为空") String deviceFrom,
            @RequestParam(value = "openId", required = false) String openId,
            @RequestParam(value = "type") @NotNull(message = "业务类型不能为空") String type,
            @RequestParam(value = "price") @NotNull(message = "支付金额不能为空") BigDecimal price,
            @RequestParam(value = "name") @NotNull(message = "订单名称不能为空") String name,
            @RequestParam(value = "detail") @NotNull(message = "订单描述不能为空") String detail,
            @RequestParam(value = "orderCode") @NotNull(message = "订单编号不能为空") String orderCode,
            @RequestParam(value = "orderId", required = false) String orderId,
            @RequestParam(value = "clientIp") @NotNull(message = "客户端ip不能为空") String clientIp,
            @RequestParam(value = "notifyUrl") @NotNull(message = "通知Url不能为空") String notifyUrl,
            @RequestParam(value = "returnUrl", required = false) String returnUrl,
            @RequestParam(value = "showUrl", required = false) String showUrl,
            @RequestParam(value = "createDate", required = true) String createDate,
            @RequestParam(value = "expireTime", required = true) String expireTime,
            @RequestParam(value = "receiptData", required = true) String receiptData,
            @RequestParam(value = "transactionId", required = true) String transactionId
    ) throws Exception {
        long startTime = System.currentTimeMillis();
        DragonPayBaseReqDto dragonPayBaseReqDto = DragonPayBaseReqDto.getNew();
        dragonPayBaseReqDto.setPayType(payType);
        dragonPayBaseReqDto.setDeviceFrom(deviceFrom);
        dragonPayBaseReqDto.setType(type);
        dragonPayBaseReqDto.setPrice(price);
        if(StringUtil.isNotNull(name)&&name.length()>=32){
            name = name.substring(0,32);
        }
        dragonPayBaseReqDto.setName(name);
        dragonPayBaseReqDto.setDetail("正在现场");
        dragonPayBaseReqDto.setOrderCode(orderCode);
        if(orderId!=null) {
            dragonPayBaseReqDto.setOrderId(orderId);
        }
        dragonPayBaseReqDto.setClientIp(clientIp);
        dragonPayBaseReqDto.setNotifyUrl(notifyUrl);
        dragonPayBaseReqDto.setReturnUrl(returnUrl);
        dragonPayBaseReqDto.setShowUrl(showUrl);
        dragonPayBaseReqDto.setCreateDate(createDate);
        dragonPayBaseReqDto.setExpireTime(expireTime);
        dragonPayBaseReqDto.setCode(IDGenerator.payCode());
        dragonPayBaseReqDto.setReceiptData(receiptData);
        dragonPayBaseReqDto.setTransactionId(transactionId);
        //调用苹果
        return ResponseDto.success( dragonOrdersService.dragonNotifyApple(dragonPayBaseReqDto));
    }

}
