package com.liquidnet.service.adam.service;

import com.liquidnet.service.adam.dto.AdamThirdPartParam;
import com.liquidnet.service.adam.dto.vo.AdamRealInfoVo;
import com.liquidnet.service.adam.dto.vo.AdamUserInfoVo;
import com.liquidnet.service.base.ResponseDto;

/**
 * <p>
 * 用户 服务类
 * </p>
 *
 * @author liquidnet
 * @since 2021-05-10
 */
public interface IAdamUserService {

    /**
     * 手机号注册
     *
     * @param mobile
     * @return AdamUserInfoVo
     */
    AdamUserInfoVo register(String mobile);

    /**
     * 手机号注册
     *
     * @param mobile
     * @param isComplete 是否标记为已完善状态[0-未完善｜1-已完善]
     * @return AdamUserInfoVo
     */
    AdamUserInfoVo register(String mobile, int isComplete);

    /**
     * 第三方账号注册
     *
     * @param param
     * @return ResponseDto<AdamUserInfoVo>
     */
    ResponseDto<AdamUserInfoVo> register(AdamThirdPartParam param);

    /**
     * 第三方账号绑定（不存在已绑定账号）
     *
     * @param uid
     * @param param
     */
    void bindTpa(String uid, AdamThirdPartParam param);

    /**
     * 第三方账号绑定（存在已绑定账号）
     *
     * @param bindUid
     * @param unBindUid
     * @param param
     */
    void bindTpaForce(String bindUid, String unBindUid, AdamThirdPartParam param);

    /**
     * 第三方账号解绑
     *
     * @param uid
     * @param platform
     */
    void unBindTpa(String uid, String platform);

    void close(String uid);

    AdamRealInfoVo identity(String uid, String name, String idCard, String mobile);
}
