/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.api.internal.toplink.embedded.websocket.handler;

import com.taobao.api.internal.toplink.embedded.websocket.WebSocket;
import com.taobao.api.internal.toplink.embedded.websocket.exception.WebSocketException;
import com.taobao.api.internal.toplink.embedded.websocket.frame.Frame;
import com.taobao.api.internal.toplink.embedded.websocket.handler.StreamHandlerAdapter;
import com.taobao.api.internal.toplink.embedded.websocket.handler.StreamHandlerChain;
import com.taobao.api.internal.toplink.embedded.websocket.impl.WebSocketImpl;
import java.nio.ByteBuffer;
import java.util.Random;

public class MaskFrameStreamHandler
extends StreamHandlerAdapter {
    private static Random random = new Random();

    public void nextUpstreamHandler(WebSocket ws, ByteBuffer buffer, Frame frame, StreamHandlerChain chain) throws WebSocketException {
        if (ws instanceof WebSocketImpl) {
            chain.nextUpstreamHandler(ws, buffer, frame);
            return;
        }
        ByteBuffer buf = ByteBuffer.allocate(4 + buffer.remaining());
        int limit = buffer.limit();
        buffer.limit(buffer.position() + 2);
        buf.put(buffer);
        buf.putInt(random.nextInt());
        buffer.limit(limit);
        buf.put(buffer);
        buf.flip();
        byte[] maskkey = new byte[4];
        buf.position(buf.position() + 2);
        buf.get(maskkey, 0, 4);
        int m = 0;
        while (buf.hasRemaining()) {
            int position = buf.position();
            buf.put((byte)(buf.get(position) ^ maskkey[m++ % 4]));
        }
        buf.flip();
        chain.nextUpstreamHandler(ws, buf, frame);
    }
}

