package com.liquidnet.service.kylin.controller;


import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.kylin.dto.vo.KylinPerformanceVo;
import com.liquidnet.service.kylin.dto.vo.PayDetailVo;
import com.liquidnet.service.kylin.service.impl.KylinPerformancesServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.text.ParseException;
import java.util.HashMap;
import java.util.List;

/**
 * <p>
 * 演出 前端控制器
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-05-11
 */
@Api(tags = "前端-演出")
@RestController
@RequestMapping("performance")
public class KylinPerformancesController {

    @Autowired
    private KylinPerformancesServiceImpl kylinPerformancesService;

    @GetMapping("localList")
    @ApiOperation("本地演出列表")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "timeStart", value = "演出开始时间 2021-01-01"),
            @ApiImplicitParam(type = "query", dataType = "int", name = "days", value = "时间范围 几天 今天1 三天3。。。"),
            @ApiImplicitParam(type = "query", dataType = "String", name = "title", value = "演出名称"),
            @ApiImplicitParam(type = "query", dataType = "String", name = "cityName", value = "城市名称"),
            @ApiImplicitParam(type = "query", dataType = "int", name = "type", value = "演出类型 101音乐节 102小型演出(livehouse演出) 103巡演 演出类型只有这几个了"),
//            @ApiImplicitParam(type = "query", dataType = "int", name = "type", value = "演出类型 1音乐节 2演唱会 3小型演出 4展览 6舞台剧"),

            @ApiImplicitParam(type = "query", dataType = "Integer", name = "isDiscount", value = "是否会员优惠 0 1"),
            @ApiImplicitParam(type = "query", dataType = "Integer", name = "isAdvance", value = "是否优先 0 1"),
            @ApiImplicitParam(type = "query", dataType = "Integer", name = "isExclusive", value = "是否会员专属 0 1"),

            @ApiImplicitParam(type = "query", dataType = "int", name = "page", value = "页码"),
            @ApiImplicitParam(type = "query", dataType = "int", name = "size", value = "每页数量"),

            @ApiImplicitParam(type = "query", dataType = "String", name = "orderBy", value = "排序字段 时间timeStart"),
            @ApiImplicitParam(type = "query", dataType = "String", name = "sort", value = "排序方式[DESC ASC]"),
    })
    public ResponseDto<HashMap<String, Object>> localList(
            @RequestParam(defaultValue = "") String timeStart,
            @RequestParam(defaultValue = "0") int days,
            @RequestParam(defaultValue = "") String title,
            @RequestParam(defaultValue = "") String cityName,
            @RequestParam(defaultValue = "0") int type,

            @RequestParam(defaultValue = "") Integer isDiscount,
            @RequestParam(defaultValue = "") Integer isAdvance,
            @RequestParam(defaultValue = "") Integer isExclusive,


            @RequestParam(defaultValue = "1") int page,
            @RequestParam(defaultValue = "10") int size,

            // 排序
            @RequestParam(defaultValue = "") String orderBy,
            @RequestParam(defaultValue = "") String sort
    ) {
        HashMap<String, Object> result = kylinPerformancesService.localList(
                timeStart, days, title, cityName, type,
                isDiscount, isAdvance, isExclusive,
                page, size,
                orderBy, sort
        );

        return ResponseDto.success(result);
    }

    @GetMapping("noticeList")
    @ApiOperation("演出预告列表")
    public ResponseDto<HashMap<String, Object>> noticeList() {
        HashMap<String, Object> result = kylinPerformancesService.noticeList();
        return ResponseDto.success(result);
    }

    @GetMapping("recommendList")
    @ApiOperation("推荐演出列表")
    public ResponseDto<List<KylinPerformanceVo>> recommendList() {
        List<KylinPerformanceVo> result = kylinPerformancesService.recommendList();
        return ResponseDto.success(result);
    }

    @GetMapping("exclusiveList")
    @ApiOperation("会员专属演出列表")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "int", name = "page", value = "页码"),
            @ApiImplicitParam(type = "query", dataType = "int", name = "size", value = "每页数量")
    })
    public ResponseDto<List<KylinPerformanceVo>> exclusiveList(
            @RequestParam(defaultValue = "1") int page,
            @RequestParam(defaultValue = "10") int size
    ) {
        List<KylinPerformanceVo> result = kylinPerformancesService.exclusiveList(page, size);
        return ResponseDto.success(result);
    }

    @GetMapping(value = "search")
    @ApiOperation("演出搜索")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "title", value = "演出名称", required = true),
            @ApiImplicitParam(type = "query", dataType = "int", name = "page", value = "页码"),
            @ApiImplicitParam(type = "query", dataType = "int", name = "size", value = "每页数量")
    })
    public ResponseDto<HashMap> performancesSearch(
            @RequestParam String title,
            @RequestParam(defaultValue = "1") int page,
            @RequestParam(defaultValue = "10") int size
    ) {
        HashMap result = null;
        result = kylinPerformancesService.performancesSearch(title, page, size);
        return ResponseDto.success(result);
    }

    @GetMapping(value = "calendar")
    @ApiOperation("演出日历")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "yearMonth", value = "年月 2021-01", required = true),
            @ApiImplicitParam(type = "query", dataType = "String", name = "cityName", value = "城市名称", required = true)
    })
    public ResponseDto<List> performanceCalendar(@RequestParam String yearMonth, @RequestParam String cityName) throws ParseException {
        List result = null;
        result = kylinPerformancesService.performanceCalendar(yearMonth, cityName);
        return ResponseDto.success(result);
    }

    @GetMapping(value = "calendarPerformances")
    @ApiOperation("演出日历-演出列表")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "yearMonthDay", value = "年月日 2021-01-01", required = true),
            @ApiImplicitParam(type = "query", dataType = "String", name = "cityName", value = "城市名称", required = true)
    })
    public ResponseDto<List> calendarPerformances(@RequestParam String yearMonthDay, @RequestParam String cityName) {
        List result = null;
        result = kylinPerformancesService.calendarPerformances(yearMonthDay, cityName);
        return ResponseDto.success(result);
    }

    @GetMapping(value = "list")
    @ApiOperation("根据多个演出id获取演出列表-Adam")
    @ApiImplicitParam(type = "query", dataType = "String", name = "performancesIds", value = "多演出id", required = true)
    public ResponseDto<List<KylinPerformanceVo>> performanceList(@RequestParam String... performancesIds) {
        List<KylinPerformanceVo> result = kylinPerformancesService.performanceList(performancesIds);
        return ResponseDto.success(result);
    }

    @GetMapping("{performancesId}")
    @ApiOperation("演出详情")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "path", dataType = "String", name = "performancesId", value = "演出id", required = true),
            @ApiImplicitParam(type = "query", dataType = "double", name = "latitudeFrom", value = "经纬度"),
            @ApiImplicitParam(type = "query", dataType = "double", name = "longitudeFrom", value = "经纬度")
    })
    public ResponseDto<KylinPerformanceVo> detail(
            @PathVariable("performancesId") String performancesId,
            @RequestParam(defaultValue = "0") double latitudeFrom,
            @RequestParam(defaultValue = "0") double longitudeFrom
    ) {
        KylinPerformanceVo result = kylinPerformancesService.detail(performancesId, latitudeFrom, longitudeFrom);
        if (result != null) {
            return ResponseDto.success(result);
        } else {
            return ResponseDto.failure("获取演出详情失败");
        }
    }

    @GetMapping("partner/{performancesId}")
    @ApiOperation("场次票种")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "path", dataType = "String", name = "performancesId", value = "演出id", required = true),
            @ApiImplicitParam(type = "query", dataType = "Integer", name = "isAgent", value = "是否分销 1是 0不是 空/不传/0")
    })
    public ResponseDto<HashMap<String, Object>> ticketTimesPartner(
            @PathVariable("performancesId") String performancesId,
            @RequestParam(defaultValue = "0") Integer isAgent
    ) {
        HashMap<String, Object> result = kylinPerformancesService.ticketTimesPartner(performancesId, isAgent);
        if (result.size() > 0) {
            return ResponseDto.success(result);
        } else {
            return ResponseDto.failure("获取演出场次票种失败");
        }
    }

    @GetMapping("payDetail")
    @ApiOperation("支付前详情")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "performancesId", value = "演出id", required = true),
            @ApiImplicitParam(type = "query", dataType = "String", name = "ticketsId", value = "票种id", required = true)
    })
    public ResponseDto<PayDetailVo> payDetail(
            @RequestParam("performancesId") String performancesId,
            @RequestParam("ticketsId") String ticketsId
    ) {
        PayDetailVo result = kylinPerformancesService.payDetail(performancesId, ticketsId);
        if (result != null) {
            return ResponseDto.success(result);
        } else {
            return ResponseDto.failure("获取演出详情失败");
        }
    }

}
