package com.liquidnet.service.goblin.dto.vo;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.liquidnet.service.base.PagedResult;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel(value = "GoblinUserDigitalArtworkPageVo", description = "我的藏品信息")
@JsonIgnoreProperties(ignoreUnknown = true)
public class GoblinUserDigitalArtworkPageVo implements Cloneable {
    @ApiModelProperty(position = 11, value = "藏品数量")
    private int artworkNum;
    @ApiModelProperty(position = 12, value = "藏品列表分页数据")
    private PagedResult<GoblinUserDigitalArtworkListVo> pagedResult;

    public int getArtworkNum() {
        return artworkNum;
    }

    public PagedResult<GoblinUserDigitalArtworkListVo> getPagedResult() {
        return pagedResult;
    }

    public GoblinUserDigitalArtworkPageVo setArtworkNum(int artworkNum) {
        this.artworkNum = artworkNum;
        return this;
    }

    public GoblinUserDigitalArtworkPageVo setPagedResult(PagedResult<GoblinUserDigitalArtworkListVo> pagedResult) {
        this.pagedResult = pagedResult;
        return this;
    }

    private static final GoblinUserDigitalArtworkPageVo obj = new GoblinUserDigitalArtworkPageVo();

    public static GoblinUserDigitalArtworkPageVo getNew() {
        try {
            return (GoblinUserDigitalArtworkPageVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GoblinUserDigitalArtworkPageVo();
        }
    }
}
