package com.liquidnet.service.stone.vo;

import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.service.stone.entity.StoneScoreItems;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

@Data
@ApiModel
public class StoneItemListVo implements Serializable, Cloneable {
    /**
     * id
     */
    @ApiModelProperty(value = "id", example = "1")
    private String itemId;

    /**
     * 积分物品封面图
     */
    @ApiModelProperty(value = "积分物品封面图", example = "http://xxxxx.png")
    private String img;

    /**
     * 积分物品名称
     */
    @ApiModelProperty(value = "积分物品名称", example = "测试券")
    private String targetTitle;

    /**
     * 目标类型[1-券|1x-商品维度|2x-演出维度]
     */
    @ApiModelProperty(value = "目标类型[1-券|1x-商品维度|2x-演出维度]", example = "1")
    private Integer type;

    /**
     * 积分
     */
    @ApiModelProperty(value = "积分", example = "100.00")
    private Integer score;

    /**
     * 价格
     */
    @ApiModelProperty(value = "价格", example = "0.00")
    private BigDecimal price;

    /**
     * 状态状态[-999-全部|-1-删除|0-未上架|1-已上架|2-定时上架|7-已下架|8-售罄]
     */
    @ApiModelProperty(value = "状态状态[-999-全部|-1-删除|0-未上架|1-已上架|2-定时上架|7-已下架|8-售罄]", example = "1")
    private Integer status;

    private static final StoneItemListVo obj = new StoneItemListVo();

    public static StoneItemListVo getNew() {
        try {
            return (StoneItemListVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new StoneItemListVo();
        }
    }

    public StoneItemListVo copy(StoneScoreItems source) {
        if (null == source) return this;
        this.setItemId(source.getItemId());
        this.setImg(source.getImg());
        this.setTargetTitle(source.getTargetTitle());
        this.setType(source.getType());
        this.setScore(source.getScore().intValue());
        this.setPrice(source.getPrice());
        LocalDateTime now = LocalDateTime.now();
        if (source.getStatus() == 2) {
            if (now.isAfter(source.getStartTime())) {//未上架
                this.setStatus(2);
            } else if (now.isBefore(source.getEndTime())) {//已下架
                this.setStatus(7);
            } else {
                this.setStatus(1);//上架中
            }
        }else{
            this.setStatus(source.getStatus());
        }
        return this;
    }
}
