package com.liquidnet.service.feign.platform.api;

import com.liquidnet.service.kylin.dto.vo.ticketSystem.CheckVo;
import feign.hystrix.FallbackFactory;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

@Component
@FeignClient(
        name = "liquidnet-service-platform",
        contextId = "FeignPlatformTicketSystemClient",
        path = "platform",
        url = "${liquidnet.service.platform.url}",
        fallback = FallbackFactory.Default.class
)
public interface FeignPlatformTicketSystemClient {

    @PostMapping("st/check/insert")
    void insertCheck(@RequestBody List<CheckVo> ticketList);
}
