package com.liquidnet.service.dragon.constant;

/**
 *
 */
public class DragonConstant {

    public static final String REFUND_TYPE_APP_ALIPAY="APPALIPAY";//,"App内支付宝支付"),
    public static final String REFUND_TYPE_APP_WEPAY="APPWEPAY";//,"App内微信支付"),
    public static final String REFUND_TYPE_APP_IAP="APPIAP";//,"App内IAP(In-App Purchase)支付，iOS虚拟道具支付"),
    public static final String REFUND_TYPE_WAP_ALIPAY="WAPALIPAY";//,"手机网页内支付宝支付"),
    public static final String REFUND_TYPE_WAP_WEPAY="WAPWEPAY";//,"手机网页调起微信支付"),
    public static final String REFUND_TYPE_WEB_ALIPAY="WEBALIPAY";//,"电脑网页内支付宝即时到账支付"),
    public static final String REFUND_TYPE_WEB_WEPAY="WEBWEPAY";//,"电脑网页内微信二维码支付，用户打开微信扫码支付"),
    public static final String REFUND_TYPE_JS_WEPAY="JSWEPAY";//,"微信内网页、微信公众号"),
    public static final String REFUND_TYPE_WAP_UNION="WAPUNIONPAY";//,"微信内网页、微信公众号"),
    public static final String REFUND_TYPE_APP_UNION="APPUNIONPAY";//,"微信内网页、微信公众号"),
    public static final String REFUND_TYPE_APPLET_DOUYIN="APPLETDOUYINPAY";//,"applet 抖音支付"),
    public static final String REFUND_TYPE_APPLET_WEPAY="APPLETWEPAY";//,"微信小程序");
    public static final String REFUND_TYPE_MICROPAY_WEPAY="MICROPAYWEPAY";//,"扫码枪微信支付");
    public static final String REFUND_TYPE_MICROPAY_ALIPAY="MICROPAYALIPAY";//,"扫码枪微信支付");


    public static final String REFUND_REDIS_KET="dragon:refund:refundCode:";// 订单号对应回调地址
    public static final String ORDERCODE_REDIS_KET="dragon:refund:orderCode:";// 退款订单号对应 支付订单号
    public static final String REDIS_KET_PAY_CODE="dragon:pay:code:";// 支付流水号
    public static final String REDIS_KET_ORDERCODE_PAY_CODE="dragon:ordercode:pay:code:";// 支付流水号

    public enum PayChannelEnum{
        ALIPAY("alipay","支付宝"),
        WEPAY ("wepay","微信"),
        APPLEPAY ("applepay","applepay"),
        UNIONPAY("unionpay","云闪付"),
        DOUYINPAY ("douyinpay","抖音"),
        CLOUDPAY("cloudpay","云闪付");
        private String code;
        private String message;
        PayChannelEnum(String code, String message) {
            this.code = code;
            this.message = message;
        }

        public String getCode() {
            return code;
        }
    }

    public enum DeviceFromEnum{
        WEB("web",""),WAP("wap",""),WAPPAGE("wappage","")
        ,APP("app",""),JS("js",""),APPLET("applet",""),MICROPAY("micropay","");
        private String code;
        private String message;
        DeviceFromEnum(String code, String message) {
            this.code = code;
            this.message = message;
        }
        public String getCode() {
            return code;
        }
    }
    /**
     * 支付状态
     */
    public enum PayStatusEnum{
        STATUS_UNPAID("0","未支付，或支付中"),
        STATUS_PAID("1","已支付"),
        STATUS_PAY_FAIL("2","支付失败");


        private String code;
        private String message;
        PayStatusEnum(String code, String message) {
            this.code = code;
            this.message = message;
        }

        public PayStatusEnum getEnumByCode(String code){
            PayStatusEnum[] arry = PayStatusEnum.values();
            for (int i = 0; i < arry.length; i++) {
                if (arry[i].getCode().equals(code)) {
                    return arry[i];
                }
            }
            return null;
        }

        public String getCode() {
            return code;
        }
    }

    /**
     * 支付商户通知状态
     */
    public enum PayNotifyStatusEnum{
        NOTIFY_INIT("0","初始化"),
        NOTIFY_SUCCESS("1","已支付，通知成功，交易结束"),
        NOTIFY_FAIL("2","已支付，通知失败，交易结束"),
        NOTIFY_EXPIRE("3","已支付，通知超时，交易结束");
        private String code;
        private String message;
        PayNotifyStatusEnum(String code, String message) {
            this.code = code;
            this.message = message;
        }

        public PayNotifyStatusEnum getEnumByCode(String code){
            PayNotifyStatusEnum[] arry = PayNotifyStatusEnum.values();
            for (int i = 0; i < arry.length; i++) {
                if (arry[i].getCode().equals(code)) {
                    return arry[i];
                }
            }
            return null;
        }

        public String getCode() {
            return code;
        }
    }

    /**
     * 退款状态
     */
    public enum RefundStatusEnum{
        STATUS_UNFILLED("0","未处理"),
        STATUS_REFUNDED("1","退款成功"),
        STATUS_SUCCESS("2","退款成功，通知成功，交易结束"),
        STATUS_FAIL("3","退款成功，通知失败，交易结束"),
        STATUS_EXPIRE("4","退款成功，通知超时，交易结束"),
        STATUS_REFUNDING("5","正在退款"),
        STATUS_ERROR("6","退款失败"),
        STATUS_ERROR_SUCCESS("7","退款失败，通知成功，交易结束"),
        STATUS_ERROR_FAIL("8","退款失败，通知失败，交易结束"),
        STATUS_ERROR_EXPIRE("9","退款失败，通知超时，交易结束");

        private String code;
        private String message;
        RefundStatusEnum(String code, String message) {
            this.code = code;
            this.message = message;
        }

        public String getCode() {
            return code;
        }
    }

    /**
     * 支付业务类型
     */
    public enum BussinessTypeEnum{
        TYPE_TICKET("TICKET","票务购买（实物购买）"),
        TYPE_PRODUCT("PRODUCT","商品购买（实物购买）"),
        TYPE_COST("COST","活动资费（活动成本费、活动报名费）"),
        TYPE_MBEANS("MBEANS","点豆充值（虚拟道具）"),
        TYPE_LIVE("LIVE","直播付费（数字资产）"),
        TYPE_VIDEO("VIDEO","点播付费（数字资产）"),
        TYPE_VIP("VIP","会员购买（数字+实物资产）"),
        TYPE_CLUB("CLUB","会员购买（数字+实物资产）"),
        TYPE_STRAWBERRY("STRAWBERRY","现场购买 (实物资产)");

        private String code;
        private String message;
        BussinessTypeEnum(String code, String message) {
            this.code = code;
            this.message = message;
        }

        public String getCode() {
            return code;
        }
    }

    /**
     * 支付类型
     */
    public enum PayTypeEnum{
        PAYMENT_TYPE_APP_ALIPAY("APPALIPAY","alipay","app","App内支付宝支付"),
        PAYMENT_TYPE_APP_WEPAY("APPWEPAY","wepay","app","App内微信支付"),
        PAYMENT_TYPE_APP_IAP("APPIAP","iap","app","App内IAP(In-App Purchase)支付，iOS虚拟道具支付"),
        PAYMENT_TYPE_WAP_ALIPAY("WAPALIPAY","alipay","wap","手机网页内支付宝支付"),
        PAYMENT_TYPE_WAP_WEPAY("WAPWEPAY","wepay","wap","手机网页调起微信支付"),
        PAYMENT_TYPE_WEB_ALIPAY("WEBALIPAY","alipay","web","电脑网页内支付宝即时到账支付"),
        PAYMENT_TYPE_MICROPAY_ALIPAY("MICROPAYALIPAY","alipay","micropay","支付宝扫码枪支付"),
        PAYMENT_TYPE_WEB_WEPAY("WEBWEPAY","wepay","web","电脑网页内微信二维码支付，用户打开微信扫码支付"),
        PAYMENT_TYPE_JS_WEPAY("JSWEPAY","wepay","js","微信内网页、微信公众号"),
        PAYMENT_TYPE_APPLET_WEPAY("APPLETWEPAY","wepay","applet","微信小程序"),
        PAYMENT_TYPE_APPLETB_WEPAY("APPLETBWEPAY","wepay","applet","微信小程序"),
        PAYMENT_TYPE_MICROPAY_WEPAY("MICROPAYWEPAY","wepay","micropay","微信扫码枪支付"),
        PAYMENT_TYPE_APPLET_DOUYINPAY("APPLETDOUYINPAY","douyinpay","applet","抖音小程序"),
        PAYMENT_TYPE_WAP_UNIONPAY("WAPUNIONPAY","unionpay","wap","银联wap支付"),
        PAYMENT_TYPE_APP_UNIONPAY("APPUNIONPAY","unionpay","wap","银联wap支付");

        private String code;
        private String message;
        private String payType;
        private String deviceFrom;
        PayTypeEnum(String code,String payType,String deviceFrom,String message) {
            this.code = code;
            this.message = message;
            this.payType = payType;
            this.deviceFrom = deviceFrom;
        }

        public String getCode() {
            return code;
        }

        public static PayTypeEnum getEnumByCode(String code){
            PayTypeEnum[] arry = PayTypeEnum.values();
            for (int i = 0; i < arry.length; i++) {
                if (arry[i].getCode().equals(code)) {
                    return arry[i];
                }
            }
            return null;
        }

        public String getMessage() {
            return message;
        }

        public String getPayType() {
            return payType;
        }

        public String getDeviceFrom() {
            return deviceFrom;
        }
    }

    /**
     * 退款类型
     */
    public enum RefundTypeEnum{
        REFUND_TYPE_APP_ALIPAY("APPALIPAY","App内支付宝支付"),
        REFUND_TYPE_APP_WEPAY("APPWEPAY","App内微信支付"),
        REFUND_TYPE_APP_IAP("APPIAP","App内IAP(In-App Purchase)支付，iOS虚拟道具支付"),
        REFUND_TYPE_WAP_ALIPAY("WAPALIPAY","手机网页内支付宝支付"),
        REFUND_TYPE_WAP_WEPAY("WAPWEPAY","手机网页调起微信支付"),
        REFUND_TYPE_WEB_ALIPAY("WEBALIPAY","电脑网页内支付宝即时到账支付"),
        REFUND_TYPE_WEB_WEPAY("WEBWEPAY","电脑网页内微信二维码支付，用户打开微信扫码支付"),
        REFUND_TYPE_JS_WEPAY("JSWEPAY","微信内网页、微信公众号"),
        REFUND_TYPE_APPLET_WEPAY("APPLETWEPAY","微信小程序");

        private String code;
        private String message;
        RefundTypeEnum(String code, String message) {
            this.code = code;
            this.message = message;
        }

        public String getCode() {
            return code;
        }
    }

    /**
     * MYSQL_REDIS_QUEUE
     */
    public enum MysqlRedisQueueEnum{
        //支付相关队列
        DRAGON_PAY_KEY("dragon:stream:dragon-pay","同步数据-支付"),
        DRAGON_REFUND_KEY ("dragon:stream:dragon-refund","同步数据-退款"),
        DRAGON_PAY_GROUP("dragon-pay-group","同步数据-支付-组"),
        DRAGON_REFUND_GROUP ("dragon-refund-group","同步数据-退款-组"),
        //三方异步通知相关队列
        DRAGON_PAY_NOTIFY_KEY("dragon:stream:dragon-pay-notify-key","支付异步通知"),
        DRAGON_PAY_NOTIFY_GROUP ("dragon-pay-notify-group","支付异步通知-组"),
        //商户通知相关队列
        PAY_MCH_NOTIFY_KEY("dragon:stream:pay-mch-notify-key","商户异步通知"),
        PAY_MCH_NOTIFY_GROUP ("pay-mch-notify-group","商户异步通知-组"),
        PAY_MCH_NOTIFY_ERROR_KEY("dragon:stream:pay-mch-notify-error-key","商户异步通知失败"),
        PAY_MCH_NOTIFY_ERROR_GROUP ("pay-mch-notify-error-group","商户异步通知失败-组");
        private String code;
        private String message;
        MysqlRedisQueueEnum(String code, String message) {
            this.code = code;
            this.message = message;
        }

        public String getCode() {
            return code;
        }
    }

    /**
     * CHANNEL_REDIS_QUEUE
     */
    public enum ChannelRedisQueueEnum{
        //支付回调相关队列
        WECHAT_PAY_KEY("wechat-pay","微信-支付-回调"),
        WECHAT_REFUND_KEY("wechat-refund","微信-退款-回调"),
        ALIPAY_PAY_KEY("alipay-pay","支付宝-支付-回调"),
        ALIPAY_REFUND_KEY ("alipay-refund","支付宝-退款-回调"),
        WECHAT_PAY_GROUP("wechat-pay-group","微信-支付-回调-组"),
        WECHAT_REFUND_GROUP("wechat-refund-group","微信-退款-回调-组"),
        ALIPAY_PAY_GROUP("alipay-pay-group","支付宝-支付-回调-组"),
        ALIPAY_REFUND_GROUP ("alipay-refund-group","支付宝-退款-回调-组");

        private String code;
        private String message;
        ChannelRedisQueueEnum(String code, String message) {
            this.code = code;
            this.message = message;
        }
        public String getCode() {
            return code;
        }
    }

    /**
     * CHANNEL_REFUND_URL
     */
    public enum ChannelRefundUrlEnum{
        JSAPI_REFUND_URL("https://api.mch.weixin.qq.com/v3/refund/domestic/refunds","JSAPI-退款-接口"),
        APP_REFUND_URL("https://api.mch.weixin.qq.com/v3/refund/domestic/refunds","APP-退款-接口"),
        H5_REFUND_URL("https://api.mch.weixin.qq.com/v3/refund/domestic/refunds","H5-退款-接口"),
        NATIVE_REFUND_URL ("https://api.mch.weixin.qq.com/v3/refund/domestic/refunds","NATIVE-退款-接口"),
        MCH_REFUND_URL("https://api.mch.weixin.qq.com/v3/refund/domestic/refunds","小程序-退款-接口");
        private String code;
        private String message;
        ChannelRefundUrlEnum(String code, String message) {
            this.code = code;
            this.message = message;
        }
    }

    public static void main(String[] args) {
        Integer aaa = 1;
        if(aaa.toString().equals(DragonConstant.PayStatusEnum.STATUS_PAID.getCode())){
            System.out.println("支付成功");
        }
    }
}
