package com.liquidnet.service.goblin.service.impl.manage;

import com.liquidnet.commons.lang.util.CurrentUtil;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.service.goblin.dto.manage.GoblinStoreMgtCertificationParam;
import com.liquidnet.service.goblin.dto.manage.GoblinStoreMgtCompleteParam;
import com.liquidnet.service.goblin.dto.vo.GoblinStoreInfoVo;
import com.liquidnet.service.goblin.service.manage.IGoblinStoreMgtCertificationService;
import com.liquidnet.service.goblin.util.GoblinMongoUtils;
import com.liquidnet.service.goblin.util.GoblinRedisUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;

@Slf4j
@Service
public class GoblinStoreMgtCertificationServiceImpl implements IGoblinStoreMgtCertificationService {
    @Autowired
    private GoblinRedisUtils goblinRedisUtils;
    @Autowired
    private GoblinMongoUtils goblinMongoUtils;

    @Override
    public void certificationInformationProcessing(GoblinStoreMgtCertificationParam param) {
        String uid = CurrentUtil.getCurrentUid();
        LocalDateTime now = LocalDateTime.now();

        GoblinStoreInfoVo storeInfoVo = goblinRedisUtils.getStoreInfoVoByUid(uid);
        if (null == storeInfoVo) {
            storeInfoVo = GoblinStoreInfoVo.getNew();
            storeInfoVo.setStoreId(IDGenerator.get32UUID());
            storeInfoVo.setUid(uid);
            storeInfoVo.setStatus("0");
            storeInfoVo.setCreatedAt(now);
            storeInfoVo.setCreatedBy(uid);
            storeInfoVo.setUpdatedBy(uid);
            storeInfoVo.setUpdatedAt(now);
            storeInfoVo.setCertificationVo(param.initStoreCertificationVo());

            goblinMongoUtils.setStoreInfoVo(storeInfoVo);
            goblinRedisUtils.setStoreInfoVo(storeInfoVo);
        } else {
            storeInfoVo.setStatus("0");
            storeInfoVo.setUpdatedBy(uid);
            storeInfoVo.setUpdatedAt(now);
            storeInfoVo.setCertificationVo(param.initStoreCertificationVo());

            if (goblinMongoUtils.updateStoreInfoVo(storeInfoVo)) {
                goblinRedisUtils.setStoreInfoVo(storeInfoVo);
            }
        }
    }

    @Override
    public void certificationCompleteProcessing(GoblinStoreMgtCompleteParam param) {
        String uid = CurrentUtil.getCurrentUid();
        GoblinStoreInfoVo storeInfoVo = goblinRedisUtils.getStoreInfoVoByUid(uid);
        if (null == storeInfoVo) {
            log.warn("店铺认证:完善信息:店铺信息不存在，请按流程完成第一步:[UID={}]", uid);
            return;
        }
        goblinRedisUtils.setStoreInfoVo(param.completeStoreInfoVo(storeInfoVo));
    }
}
