package com.liquidnet.service.adam.service.processor;

import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.commons.lang.util.ServletUtils;
import com.liquidnet.service.adam.dto.vo.AdamMemberPriceVo;
import com.liquidnet.service.adam.dto.vo.AdamMemberVo;
import com.liquidnet.service.adam.entity.AdamMember;
import com.liquidnet.service.adam.entity.AdamMemberPrice;
import com.liquidnet.service.adam.mapper.AdamMemberMapper;
import com.liquidnet.service.adam.mapper.AdamMemberPriceMapper;
import com.liquidnet.service.adam.service.DataMigrationProcessorService;
import com.mysql.cj.jdbc.result.ResultSetImpl;
import lombok.SneakyThrows;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletRequest;
import java.sql.SQLException;

@Slf4j
@Service
public class DMTracesInfoProcessor extends DataMigrationProcessorService {
    @Autowired
    MongoTemplate mongoTemplate;
    @Autowired
    RedisUtil redisUtil;
    @Autowired
    AdamMemberMapper memberMapper;
    @Autowired
    AdamMemberPriceMapper memberPriceMapper;

    @Override
    protected void dataProcessing(boolean flg) {
        if (StringUtils.isNotEmpty(ServletUtils.getRequest().getParameter(DM_FLUSH))) {
            log.info("DM.flush.member:{}", userMapper.executeForDM("adam_member"));
            log.info("DM.flush.member_price:{}", userMapper.executeForDM("adam_member_price"));
        }
        this.memberCardInfoHandler();
        this.memberCardPriceHandler();
    }

    @SneakyThrows
    private void memberCardInfoHandler() {
        try {
            String sql = "select id,`name`,sub_title,icon,avatar,min_card_number,if(`type`='VIP',1,0),interests_detail,notes,created_at,updated_at,is_notice,vip_notice,vip_notice_title,need_question,display_agreement,status,limitation from vip_cards";
//        1-id,2-`name`,3-sub_title,4-icon,5-avatar,6-min_card_number,7-`type`,8-interests_detail,9-notes,10-created_at,11-updated_at,12-is_notice,13-vip_notice,14-vip_notice_title,15-need_question,16-display_agreement,17-status,18-limitation
            statement = connection.prepareStatement(sql);
            row = (ResultSetImpl) statement.executeQuery();
            row.first();

            AdamMember o = new AdamMember();
            o.setMemberId(row.getString(1));
            o.setName(row.getString(2));
            o.setTitle(o.getName());
            o.setSubTitle(row.getString(3));
            o.setIcon(row.getString(4));
            o.setAvatar(row.getString(5));
            o.setStartNo(10000);
            o.setType(row.getInt(7));
            o.setInterestsDetail(row.getString(8));
            o.setNotes(row.getString(9));
            o.setCreatedAt(row.getLocalDateTime(10));
            o.setUpdatedAt(row.getLocalDateTime(11));
            o.setIsNotice(row.getInt(12));
            o.setNoticeInfo(row.getString(13));
            o.setNoticeTitle(row.getString(14));
            o.setNeedQuestion(row.getInt(15));
            o.setDisplayAgreement(row.getInt(16));
            o.setState(row.getInt(17));
            o.setLimitation(row.getInt(18));

            AdamMemberVo vo = AdamMemberVo.getNew().copy(o);

            memberMapper.insert(o);
            mongoTemplate.insert(vo, AdamMemberVo.class.getSimpleName());
        } catch (SQLException throwables) {
            throwables.printStackTrace();
        }
    }

    @SneakyThrows
    private void memberCardPriceHandler() {
        try {
            String sql = "select id,vip_card_id,status,name,price,days,detail,created_at,updated_at from vip_card_prices";
//        1-id,2-vip_card_id,3-status,4-name,5-price,6-days,7-detail,8-created_at,9-updated_at
            statement = connection.prepareStatement(sql);
            row = (ResultSetImpl) statement.executeQuery();
            row.first();

            AdamMemberPrice o = new AdamMemberPrice();
            o.setMemberPriceId(row.getString(1));
            o.setMemberId(row.getString(2));
            o.setState(row.getInt(3));
            o.setName(row.getString(4));
            o.setPrice(row.getBigDecimal(5));
            o.setPriceFixed(o.getPrice());
            o.setDays(row.getInt(6));
            o.setDetail(row.getString(7));
            o.setCreatedAt(row.getLocalDateTime(8));
            o.setUpdatedAt(row.getLocalDateTime(9));

            AdamMemberPriceVo vo = AdamMemberPriceVo.getNew();

            memberPriceMapper.insert(o);
            mongoTemplate.insert(vo, AdamMemberPriceVo.class.getSimpleName());
        } catch (SQLException throwables) {
            throwables.printStackTrace();
        }
    }





//    @SneakyThrows
//    @Override
//    protected void dataProcessing(boolean flg) {
//        String sqlCount = "select count(1) from addresses where 1=1";
//        String field = "id,user_id,user_name,user_phone,province,city,county,user_address,defaultDelivery,created_at";
////                     1-id,2-user_id,3-user_name,4-user_phone,5-province,6-city,7-county,8-user_address,9-defaultDelivery,10-created_at
//        String sql = sqlCount.replace("count(1)", field);
//
//        if (flg) {
//            sqlCount += " and user_id in ('2026628','544327','1997335','773650','809406')";
//            sql += " and user_id in ('2026628','544327','1997335','773650','809406')";
//        }
//
//        sql += " limit ?,?";
//
//        statement = connection.prepareStatement(sqlCount);
//        resultSet = statement.executeQuery();
//        resultSet.first();
//        int ct = resultSet.getInt(1), pSize = 2, num = 0;
//        log.info("DM数据迁移总数:{}", ct);
//
//
//
//        while (ct > 0) {
//            statement = connection.prepareStatement(sql);
//            statement.setInt(1, pSize * num);
//            statement.setInt(2, pSize);
//            resultSet = statement.executeQuery();
//            log.info("DM.execute.limit:[pNo:{},pSize:{}]", pSize * num, pSize);
//            while (resultSet.next()) {
//
//            }
//
//
//            num++;
//            ct -= pSize;
//        }
//    }
}
