package com.liquidnet.service.feign.candy.api;

import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.candy.vo.CandyCouponBasicVo;
import feign.hystrix.FallbackFactory;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.List;

@Component
@FeignClient(name = "liquidnet-service-candy",
        contextId = "FeignCandyBaseClient", path = "",
        url = "${liquidnet.service.candy.url}",
        fallback = FallbackFactory.Default.class)
public interface FeignCandyBaseClient {

    @PostMapping("couinfo")
    ResponseDto<List<CandyCouponBasicVo>> couponListById(
            @RequestParam("couponIds") @NotNull @NotBlank String couponIds
    );
}