package com.liquidnet.service.merchant.controller;

import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.github.xiaoymin.knife4j.annotations.ApiSupport;
import com.liquidnet.commons.lang.util.CurrentUtil;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.merchant.dto.vo.MerchantFieldCheckersVo;
import com.liquidnet.service.merchant.dto.vo.MerchantStationsVo;
import com.liquidnet.service.merchant.service.IMerchantStationsService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * <p>
 * 小站 前端控制器
 * </p>
 *
 * @author liquidnet
 * @since 2021-11-01
 */
@ApiSupport(order = 10010)
@Api(tags = "小站")
@Slf4j
@Validated
@RestController
@RequestMapping("stations")
public class MerchantStationsController {

    @Autowired
    IMerchantStationsService merchantStationsService;

    @ApiOperationSupport(order = 10)
    @ApiOperation(value = "默认小站列表")
    @GetMapping("list")
    public ResponseDto<List<MerchantStationsVo>> stationsList() {
        String currentUid = CurrentUtil.getCurrentUid();

        return ResponseDto.success(merchantStationsService.stationsList(currentUid));
    }
}
