package com.liquidnet.common.cache.redis.util;

import com.liquidnet.common.cache.redis.config.AbstractRedisConfig;
import com.liquidnet.common.cache.redis.config.RedisConfig;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @author AnJiabin <jiabin.an@lightnet.io>
 * @version V1.0
 * @Description: Redis工具类
 * @class: RedisUtil
 * @Package com.liquidnet.stellar.utils
 * @Copyright: LightNet @ Copyright (c) 2020
 * @date 2020/8/26 13:11
 */
@Slf4j
@Component("redisUtil")
public final class RedisUtil extends AbstractRedisUtil{
    @Autowired
    private RedisConfig redisConfig;

    @Override
    public int getDbs() {
//        log.info("redisConfig.totalDbs===",redisConfig.totalDbs);
        return redisConfig.totalDbs;
    }

    @Override
    AbstractRedisConfig getRedisConfig() {
        return this.redisConfig;
    }

    public static void main(String[] args) {
        String[] keys = {
                "smile:user:validate",
        };
        for (String key : keys) {
            long value = key.hashCode();
            int idx = ((int) (value ^ (value >>> 32)) % 250);
            System.out.printf("\n[%s] - idx:%s", key, idx);
        }
    }
}
