package com.liquidnet.service.feign.smile.api;

import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.goblin.dto.vo.SmileUserVO;
import feign.hystrix.FallbackFactory;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Component
@FeignClient(name = "liquidnet-service-smile",
        contextId = "FeignSmileApiClient", path = "smile",
        url = "${liquidnet.service.smile.url}",
        fallback = FallbackFactory.Default.class)
public interface FeignSmileApiClient {

    @PostMapping("frontNoLogin/getUserByid")
    ResponseDto<SmileUserVO> getUserByid(@RequestParam("userId") String userId);
}
