package com.liquidnet.service.goblin.dto;

import com.alibaba.excel.annotation.ExcelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;

/**
 * select gso.order_id                                          '订单ID',
 *        gso.user_mobile                                    as '用户手机号',
 *        gos.spu_name                                          '商品名称',
 *        gsm.name                                              '活动名称',
 *        gsi.store_name                                        '店铺名称',
 *        gso.order_code                                        '订单编号',
 *        gso.pay_code                                          '商户单号',
 *        gso.status                                            '状态',
 *        if(gso.device_from = 'micropay', 'pos机订单', '线上订单') as 支付来源,
 *        gos.push_time                                      as '核销时间',
 *        if(gso.status in (2, 3, 4), '已付款', '已退款')          as '订单状态',
 *        (case gso.pay_type
 *             when 'wepay' then '微信支付'
 *             when 'alipay' then '支付宝支付'
 *             when 'huifu' then '汇付'
 *             when 'unionpay' then '云闪付'
 *             when 'pos_crash' then '现金支付'
 *             else '0元付' end)
 *                                                              '支付类型',
 *        gos.num                                               '数量',
 *        gos.sku_price                                         '商品单价',
 *        gos.sku_price_actual                                  '实际支付价格',
 *        gos.price_voucher                                     '优惠金额',
 *        gso.created_at                                        '订单创建时间'
 * from goblin_store_order gso
 *          inner join goblin_order_sku gos on gos.order_id = gso.order_id
 *          inner join goblin_store_info gsi on gsi.store_id = gso.store_id
 *          inner join goblin_self_marketing gsm on gsm.self_market_id = SUBSTRING_INDEX(gso.market_id, 'ZZ', -1)
 * where gso.status not in (0, 5)
 *   and gso.market_id = 'ZZ223161701266386447667'
 * #     and gsi.store_name = '摩登天空官方周边售卖'
 * order by gso.created_at desc;
 */
@Getter
@Setter
public class GoblinZhengzaiMarketOrderExcelDto implements Serializable, Cloneable {
    private static final long serialVersionUID = -2804101458736599181L;
    @ExcelProperty("商品名称")
    private String spuName;
    @ExcelProperty("活动名称")
    private String marketName;
    @ExcelProperty("店铺名称")
    private String storeName;
    @ExcelProperty("订单编号")
    private String orderCode;
    @ExcelProperty("商户单号")
    private String payCode;
    @ExcelProperty("订单状态")
    private String orderStatus;
    @ExcelProperty("订单创建时间")
    private Integer createdAt;
    @ExcelProperty("核销时间")
    private String pushTime;
    @ExcelProperty("支付来源")
    private String deviceFrom;
    @ExcelProperty("支付类型")
    private String payType;
    @ExcelProperty("购买数量")
    private String nums;
    @ExcelProperty("商品单价")
    private String skuPrice;
    @ExcelProperty("实际支付价格")
    private String priceActual;
    @ExcelProperty("优惠金额")
    private Integer priceVoucher;
}
