package com.liquidnet.service.sweet.service.impl.five;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.sweet.entity.SweetManualNotifyFive;
import com.liquidnet.service.sweet.mapper.SweetManualNotifyFiveMapper;
import com.liquidnet.service.sweet.service.five.ISweetManualNotifyFiveService;
import com.liquidnet.service.sweet.utils.RedisFiveDataUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 * 电子宣传手册通知表 服务实现类
 * </p>
 *
 * @author liquidnet
 * @since 2021-08-09
 */
@Service
public class SweetManualNotifyFiveServiceImpl extends ServiceImpl<SweetManualNotifyFiveMapper, SweetManualNotifyFive> implements ISweetManualNotifyFiveService {

    @Autowired
    private SweetManualNotifyFiveMapper sweetManualNotifyFiveMapper;
    @Autowired
    private RedisFiveDataUtils redisDataUtils;

    @Override
    public ResponseDto<PageInfo<SweetManualNotifyFive>> getList(Integer page, Integer size, String title, String manualId) {
        PageInfo<SweetManualNotifyFive> pageInfo = null;
        try {
            PageHelper.startPage(page, size);
            List<SweetManualNotifyFive> data;
            if (title != null) {
                data = sweetManualNotifyFiveMapper.selectList(Wrappers.lambdaQuery(SweetManualNotifyFive.class).like(SweetManualNotifyFive::getTitle, title).eq(SweetManualNotifyFive::getManualId, manualId).eq(SweetManualNotifyFive::getStatus, 1));
            } else {
                data = sweetManualNotifyFiveMapper.selectList(Wrappers.lambdaQuery(SweetManualNotifyFive.class).eq(SweetManualNotifyFive::getManualId, manualId).eq(SweetManualNotifyFive::getStatus, 1));
            }
            pageInfo = new PageInfo(data);
            return ResponseDto.success(pageInfo);
        } catch (Exception e) {
            return ResponseDto.success(pageInfo);
        }
    }

    @Override
    public ResponseDto<Boolean> add(String manualId, String title, String content) {
        try {
            SweetManualNotifyFive sweetManualNotify = SweetManualNotifyFive.getNew();
            sweetManualNotify.setManualNotifyId(IDGenerator.nextSnowId());
            sweetManualNotify.setManualId(manualId);
            sweetManualNotify.setTitle(title);
            sweetManualNotify.setContent(content);
            sweetManualNotify.setCreatedAt(LocalDateTime.now());
            sweetManualNotifyFiveMapper.insert(sweetManualNotify);

            List<SweetManualNotifyFive> oldData = redisDataUtils.getNotifyRedisData(manualId);
            oldData.add(sweetManualNotify);
            redisDataUtils.setNotifyRedisData(manualId, oldData);

            return ResponseDto.success();
        } catch (Exception e) {
            return ResponseDto.failure();
        }
    }

    @Override
    public ResponseDto<SweetManualNotifyFive> details(String manualNotifyId) {
        try {
            return ResponseDto.success(sweetManualNotifyFiveMapper.selectOne(Wrappers.lambdaQuery(SweetManualNotifyFive.class).eq(SweetManualNotifyFive::getManualNotifyId, manualNotifyId).eq(SweetManualNotifyFive::getStatus, 1)));
        } catch (Exception e) {
            return ResponseDto.failure();
        }
    }

    @Override
    public ResponseDto<Boolean> change(String manualId, String manualNotifyId, String title, String content) {
        try {
            SweetManualNotifyFive sweetManualNotify = SweetManualNotifyFive.getNew();
            sweetManualNotify.setTitle(title);
            sweetManualNotify.setContent(content);
            sweetManualNotify.setUpdatedAt(LocalDateTime.now());
            sweetManualNotifyFiveMapper.update(sweetManualNotify, Wrappers.lambdaUpdate(SweetManualNotifyFive.class).eq(SweetManualNotifyFive::getManualNotifyId, manualNotifyId));

            List<SweetManualNotifyFive> oldData = redisDataUtils.getNotifyRedisData(manualId);
            for (SweetManualNotifyFive item : oldData) {
                if (item.getManualNotifyId().equalsIgnoreCase(manualNotifyId)) {
                    item.setTitle(title);
                    item.setContent(content);
                    item.setUpdatedAt(LocalDateTime.now());
                }
            }
            redisDataUtils.setNotifyRedisData(manualId, oldData);

            return ResponseDto.success();
        } catch (Exception e) {
            return ResponseDto.failure();
        }
    }

    @Override
    public ResponseDto<Boolean> delete(String manualNotifyId) {
        try {
            SweetManualNotifyFive sweetManualNotify = SweetManualNotifyFive.getNew();
            sweetManualNotify.setStatus(0);
            sweetManualNotify.setUpdatedAt(LocalDateTime.now());
            sweetManualNotifyFiveMapper.update(sweetManualNotify, Wrappers.lambdaUpdate(SweetManualNotifyFive.class).eq(SweetManualNotifyFive::getManualNotifyId, manualNotifyId));
            return ResponseDto.success();
        } catch (Exception e) {
            return ResponseDto.failure();
        }
    }

}
