package com.liquidnet.service.candy.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 券发放管理
 * </p>
 *
 * @author liquidnet
 * @since 2021-08-18
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class CandyMgtCoupon implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Long mid;

    private String mcouponId;

    /**
     * ~candy_coupon.coupon_id
     */
    private String couponId;

    /**
     * 发放状态[0-未发放|1-已发放|2-无效｜9-发放中]
     */
    private Integer state;

    /**
     * 发放量
     */
    private Integer eventAmt;

    /**
     * 发放类型[10-全体用户｜1-会员｜2-手机号]
     */
    private Integer eventType;

    /**
     * `发放类型`为2-手机号时发放手机号以,分隔
     */
    private String eventLimit;

    /**
     * 发放时间(立即-当前时间+3分钟｜预约-点选时间)
     */
    private LocalDateTime eventAt;

    /**
     * 操作人
     */
    private String operator;

    private LocalDateTime createdAt;

    private LocalDateTime updatedAt;

    private String comment;


}
