package com.liquidnet.service.bank.currencycloud.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * currency cloud conversion param
 */
@Data
@ApiModel(description = "currency cloud conversion param")
public class BankCcConversionCreateParam {

    @ApiModelProperty(required = true, value = "Currency purchased. Three-digit code.")
    private String buyCurrency;

    @ApiModelProperty(required = true, value = "Currency sold. Three-digit code.")
    private String sellCurrency;

    @ApiModelProperty(value = "Fix the buy or sell currency.", allowableValues = "buy,sell")
    private String fixedSide;

    @ApiModelProperty(required = true, value = "Amount of the fixed buy or sell currency.")
    private BigDecimal amount;

    @ApiModelProperty(required = true, value = "Indicates agreement to terms and conditions.")
    private Boolean termAgreement = true;

    @ApiModelProperty(value = "Earliest delivery date in UTC time zone. Format YYYY-MM-DD.")
    private Date conversionDate;

    private BigDecimal clientBuyAmount;

    private BigDecimal clientSellAmount;

    private String reason;

    private String uniqueRequestId;

    @ApiModelProperty(value = "Available only if conversion_date is not provided. Must be one of the following:\n" +
            "'earliest' for earliest available conversion date. Make sure there is sufficient time to send funds to Currencycloud.\n" +
            "'default' for conversion - T+1 for APAC, T+2 for everywhere else.\n" +
            "'optimize_liquidity' for maximizing chances of getting a successful rate. Most relevant for exotic pairs. Conversion is within 1 or 2 working days depending on currencies.", allowableValues = "earliest,default,optimize_liquidity")
    private String conversionDatePreference;

    private String contactId;

}
