package com.liquidnet.service.sweet.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

@Data
@ApiModel
public class SweetManualAppletDto implements Serializable ,Cloneable{
    private static final long serialVersionUID = -2815790292441892142L;
    @ApiModelProperty("电子手册id")
    private String manualId;
    @ApiModelProperty("演出id")
    private String performancesId;
    @ApiModelProperty("演出标题")
    private String title;
    @ApiModelProperty("场地id")
    private String fieldId;
    @ApiModelProperty("场地名称")
    private String fieldName;
    @ApiModelProperty("城市名称")
    private String cityName;
    @ApiModelProperty("演出开始时间")
    private String timeStart;
    @ApiModelProperty("演出结束时间")
    private String timeEnd;
    @ApiModelProperty("演出开售时间")
    private String timeSell;
    @ApiModelProperty("是否会员")
    private Integer isMember;
    @ApiModelProperty("提前时间")
    private Integer payCountdownMinute;

    @ApiModelProperty("经度")
    private String longitude;
    @ApiModelProperty("纬度")
    private String latitude;

    @ApiModelProperty("是否发布手册 0：不发布 1：发布")
    private Integer isReleaseManual;

    @ApiModelProperty("是否距离今日最近 0：否 1：是")
    private Integer isNear;


    private static final SweetManualAppletDto obj = new SweetManualAppletDto();
    public static SweetManualAppletDto getNew() {
        try {
            return (SweetManualAppletDto) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new SweetManualAppletDto();
        }
    }
}
