package com.liquidnet.service.account.wallet.dto.base;

import com.liquidnet.service.account.common.ErrorConstants;
import io.swagger.annotations.ApiModelProperty;

public class WalletCallResult<T> implements java.io.Serializable {
    private static final long serialVersionUID = 6882160100387848165L;

    @ApiModelProperty(position = 1, value = "State code")
    protected String code;
    @ApiModelProperty(position = 2, value = "State description")
    protected String message;
    @ApiModelProperty(position = 3, value = "Return data")
    protected T data;

    public WalletCallResult() {
        this.code = ErrorConstants.SUCCESS_CODE;
        this.message = ErrorConstants.SUCCESS_DETAILS;
    }

    public WalletCallResult(T data) {
        this.code = ErrorConstants.SUCCESS_CODE;
        this.message = ErrorConstants.SUCCESS_DETAILS;
        this.data = data;
    }

    public WalletCallResult(String code, String message) {
        this.code = code;
        this.message = message;
    }

    public String getCode() {
        return code;
    }

    public String getMessage() {
        return message;
    }

    public T getData() {
        return data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public boolean isProcessing() {
        return this.code.equals(ErrorConstants.PROCESSING_CODE);
    }

    public boolean isSuccess() {
        return this.code.equals(ErrorConstants.SUCCESS_CODE);
    }

    public boolean isFailed() {
        return !this.code.equals(ErrorConstants.SUCCESS_CODE) && !this.code.equals(ErrorConstants.PROCESSING_CODE);
    }
}
