package com.liquidnet.service.adam.controller.admin;

import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.github.xiaoymin.knife4j.annotations.ApiSupport;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.adam.dto.AdamMemberParam;
import com.liquidnet.service.adam.entity.AdamMember;
import com.liquidnet.service.adam.service.admin.IAdamMemberAdminService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

@ApiSupport(order = 90060)
@Api(tags = "后台管理:会员信息")
@Slf4j
@RestController
@RequestMapping("/admin/member")
public class AdamMemberAdminController {

    @Autowired
    IAdamMemberAdminService adamMemberService;
    @Autowired
    AmqpTemplate amqpTemplate;


    @ApiOperationSupport(order = 1)
    @ApiOperation(value = "添加会员")
    @PostMapping("add")
    public ResponseDto<Object> add(@RequestBody AdamMemberParam parameter) {
        AdamMember adamMember = new AdamMember();
        BeanUtils.copyProperties(parameter, adamMember);

        adamMember.setLimitation(1000);
        adamMember.setType(1);
        adamMember.setStartNo(1000);
        adamMember.setMemberId(String.valueOf(IDGenerator.nextSnowId()));
        adamMemberService.add(parameter);
        return ResponseDto.success();
    }

}
