/*
 * Copyright 2015-2102 RonCoo(http://www.roncoo.com) Group.
 *  
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *  
 *      http://www.apache.org/licenses/LICENSE-2.0
 *  
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.liquidnet.service.reconciliation.biz;

import com.liquidnet.service.reconciliation.constant.ReconConstants.BankChannelEnum;
import com.liquidnet.service.reconciliation.constant.ReconConstants.TransStatusEnum;
import com.liquidnet.service.reconciliation.service.core.ILrTradePaymentQueryService;
import com.liquidnet.service.reconciliation.strategy.infodata.GetInfoDataStrategyContext;
import com.liquidnet.service.reconciliation.vo.ReconciliationEntityVo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.text.SimpleDateFormat;
import java.util.*;

/**
 * @author AnJiabin <jiabin.an@lightnet.io>
 * @version V1.0
 * @Description: 平台数据获取biz业务类
 * @class: ReconciliationDataGetBiz
 * @Package com.liquidnet.service.reconciliation.biz
 * @Copyright: LightNet @ Copyright (c) 2020
 * @date 2020/10/21 14:20
 */
@Component("reconciliationDataGetBiz")
public class ReconciliationDataGetBiz {

	private static final Log LOG = LogFactory.getLog(ReconciliationDataGetBiz.class);

	@Autowired
	private GetInfoDataStrategyContext getInfoDataStrategyContext;

	/**
	 * 获取平台指定支付渠道、指定订单日下[所有成功]的数据
	 * 
	 * @param billDate
	 *            账单日
	 * @param bankChannelEnum
	 *            支付渠道
	 * @return
	 */
	public List<ReconciliationEntityVo> getSuccessPlatformDateByBillDate(Date billDate, BankChannelEnum bankChannelEnum,boolean onlySuccess) {
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
		String billDateStr = sdf.format(billDate);

		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("beginDate", billDateStr);
		paramMap.put("endDate", billDateStr);
		paramMap.put("onlySuccess", onlySuccess);
		paramMap.put("status", "completed");

		LOG.info("开始查询平台支付成功的数据：billDate[" + billDateStr + "],支付方式为[" + bankChannelEnum.getCode() + "]");
		List<ReconciliationEntityVo> recordList = getInfoDataStrategyContext.getStrategy(bankChannelEnum.getCode()).getTransInfoData(paramMap);
		if (recordList == null) {
			recordList = new ArrayList<ReconciliationEntityVo>();
		}
		LOG.info("查询得到的数据count[" + recordList.size() + "]");
		return recordList;

	}

	/**
	 * 获取平台指定支付渠道、指定订单日下[所有]的数据
	 * @param billDate
	 * @param bankChannelEnum
	 * @return
	 */
	public List<ReconciliationEntityVo> getAllPlatformDateByBillDate(Date billDate, BankChannelEnum bankChannelEnum) {
		return this.getSuccessPlatformDateByBillDate(billDate,bankChannelEnum,false);

	}
}
