package com.liquidnet.service;

import lombok.extern.slf4j.Slf4j;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.data.redis.RedisAutoConfiguration;
import org.springframework.boot.autoconfigure.data.redis.RedisRepositoriesAutoConfiguration;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.core.env.Environment;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;

/**
 * SequenceApplication.class
 *
 * @author zhanggb
 * Created by IntelliJ IDEA at 2020/9/24
 */
@Slf4j
@MapperScan(basePackages = {
        "com.liquidnet.service.sequence.mapper"
})
@SpringBootApplication(
        scanBasePackages = {"com.liquidnet"},
        exclude = {
                RedisAutoConfiguration.class,
                RedisRepositoriesAutoConfiguration.class
        }
)
public class ServiceSequenceApplication implements CommandLineRunner {
    @Autowired
    private Environment environment;

    public static void main(String[] args) {
        SpringApplication.run(ServiceSequenceApplication.class, args);
    }

    @Override
    public void run(String... strings) throws Exception {
        try {
            log.info("\n----------------------------------------------------------\n\t" +
                            "Application '{}' is running! Access URLs:\n\t" +
                            "Local: \t\thttp://127.0.0.1:{}\n\t" +
                            "External: \thttp://{}:{}\n\t" +
                            "Profile(s): \t{}\n----------------------------------------------------------",

                    environment.getProperty("spring.application.name"),
                    environment.getProperty("server.port"),
                    InetAddress.getLocalHost().getHostAddress(),
                    environment.getProperty("server.port"),
                    Arrays.toString(environment.getActiveProfiles()));
        } catch (UnknownHostException e) {
            e.printStackTrace();
        }
    }
}
