package com.liquidnet.service.goblin.controller;

import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.goblin.dto.vo.GoblinSelfMarketingVo;
import com.liquidnet.service.goblin.dto.vo.GoblinZhengzaiGoodVo;
import com.liquidnet.service.goblin.service.IGoblinStoreZhengzaiService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.validation.Valid;
import java.util.List;

@Slf4j
@Api(tags = "正在下单相关-商铺")
@RestController
@RequestMapping("/zhengzai/store")
public class GoblinStoreZhengzaiController {

    @Autowired
    IGoblinStoreZhengzaiService goblinStoreZhengzaiService;

    @GetMapping("market/list")
    @ApiOperation("正在下单-活动列表")
    public ResponseDto<List<GoblinSelfMarketingVo>> getZhengzaiMarketList() {
        return goblinStoreZhengzaiService.getZhengzaiMarketList();
    }

    @GetMapping("spu/list")
    @ApiOperation("正在下单-参与活动的spu")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "marketId", value = "活动id", example = "1"),
    })
    public ResponseDto<List<GoblinZhengzaiGoodVo>> getStoreList(@RequestParam("marketId") @Valid String marketId) {
        return goblinStoreZhengzaiService.getSpuList(marketId);
    }
}
