package com.liquidnet.service.goblin.dto.manage;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;


@ApiModel(value = "MixOrderParam")
@Data
public class MixOrderParam {

    @ApiModelProperty(value = "用户id")
    private String uid;
    @ApiModelProperty(value = "混合售id")
    private String mixId;
    @ApiModelProperty(value = "入场人地址vo")
    private AddressVo addressesVo;
    @ApiModelProperty(value = "支付类型")
    @NotNull(message = "支付类型不能为空")
    private String payType;
    @ApiModelProperty(value = "支付来源 [新增micropay-微信扫码支付]")
    @NotNull(message = "支付来源不能为空")
    private String deviceFrom;
    @ApiModelProperty(value = "openId")
    private String openId;
    @ApiModelProperty(value = "showUrl")
    private String showUrl;
    @ApiModelProperty(value = "returnUrl")
    private String returnUrl;

}
