package com.liquidnet.service.goblin.controller;

import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.github.xiaoymin.knife4j.annotations.ApiSupport;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.goblin.dto.vo.*;
import com.liquidnet.service.goblin.service.manage.IGoblinMixAppService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 正在下单活动管理
 */
@ApiSupport(order = 149201)
@Slf4j
@RestController
@Api(tags = "前端-混合售")
@RequestMapping("app/mix")
public class GoblinMixAppController {

    @Autowired
    IGoblinMixAppService goblinMixAppService;

    @ApiOperationSupport(order = 1)
    @ApiOperation(value = "列表")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "Integer", name = "showPosition", value = "展示位置[1-商城|2-数字藏品]"),
    })
    @GetMapping("list")
    public ResponseDto<List<GoblinMixAppListVo>> list(@RequestParam(value = "showPosition", required = true) Integer showPosition) {
        return goblinMixAppService.mixList(showPosition);
    }

    @ApiOperationSupport(order = 2)
    @ApiOperation(value = "详情")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "mixId", value = "混合售id"),
    })
    @GetMapping("details")
    public ResponseDto<GoblinMixAppDetailsVo> details(@RequestParam(value = "mixId", required = true) String mixId) {
        return goblinMixAppService.mixDetails(mixId);
    }

    @ApiOperationSupport(order = 3)
    @ApiOperation(value = "获取售卖内容")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "mixId", value = "混合售id"),
    })
    @GetMapping("item")
    public ResponseDto<List<GoblinMixDetailsItemVo>> item(@RequestParam(value = "mixId", required = true) String mixId) {
        return goblinMixAppService.getItem(mixId);
    }
}
