package com.liquidnet.service.goblin.service.impl;

import com.alibaba.fastjson.JSON;
import com.github.pagehelper.PageInfo;
import com.liquidnet.commons.lang.util.CollectionUtil;
import com.liquidnet.commons.lang.util.CurrentUtil;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.base.SqlMapping;
import com.liquidnet.service.base.constant.MQConst;
import com.liquidnet.service.goblin.dto.vo.*;
import com.liquidnet.service.goblin.param.GoblinMixDetailsItemParam;
import com.liquidnet.service.goblin.param.GoblinMixDetailsParam;
import com.liquidnet.service.goblin.param.GoblinMixUpdateParam;
import com.liquidnet.service.goblin.service.manage.IGoblinMixAppService;
import com.liquidnet.service.goblin.service.manage.IGoblinMixService;
import com.liquidnet.service.goblin.util.*;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

import static com.liquidnet.commons.lang.util.DateUtil.DTF_YMD_HMS;

/**
 * <p>
 * 商城-名单表 服务实现类
 * </p>
 *
 * @author liquidnet
 * @since 2022-04-29
 */
@Service
@Slf4j
public class GoblinMixAppServiceImpl implements IGoblinMixAppService {

    @Autowired
    GoblinRedisUtils redisUtils;


    @Override
    public ResponseDto<List<GoblinMixAppListVo>> mixList(Integer showPosition) {
        List<GoblinMixAppListVo> voList = ObjectUtil.goblinMixAppListVo();
        List<String> startList = CollectionUtil.linkedListString();
        List<String> stockList = CollectionUtil.linkedListString();
        if (showPosition == 1) {//商城
            startList = redisUtils.getGoblinMixSkuStartList();
            stockList = redisUtils.getGoblinMixSkuStockList();
        } else if (showPosition == 2) {//nft
            startList = redisUtils.getGoblinMixNftStartList();
            stockList = redisUtils.getGoblinMixNftStockList();
        } else {
            return ResponseDto.failure();
        }
        for (String mixId : startList) {
            GoblinMixDetailsVo vo = redisUtils.getMixDetails(mixId);
            GoblinMixAppListVo itemVo = GoblinMixAppListVo.getNew().copy(vo);
            itemVo.setStatus(6);
            voList.add(itemVo);
        }

        for (String mixId : stockList) {
            GoblinMixDetailsVo vo = redisUtils.getMixDetails(mixId);
            GoblinMixAppListVo itemVo = GoblinMixAppListVo.getNew().copy(vo);
            itemVo.setStatus(8);
            voList.add(itemVo);
        }

        return ResponseDto.success(voList);
    }

    @Override
    public ResponseDto<GoblinMixAppDetailsVo> mixDetails(String mixId) {
        GoblinMixDetailsVo baseVo = redisUtils.getMixDetails(mixId);
        GoblinMixAppDetailsVo vo = GoblinMixAppDetailsVo.getNew().copy(baseVo);
        int stock = 0;
        for (GoblinMixDetailsItemVo item : vo.getItem()) {
            item.setStock(0);
            GoblinGoodsSkuInfoVo skuInfoVo = redisUtils.getGoodsSkuInfoVo(item.getSkuId());
            if (skuInfoVo.getUnbox().equals("1")) {
                List<String> relationIds = redisUtils.getGoblinMixRelationBox(item.getSkuId(), vo.getMixId());
                for (String skuId : relationIds) {
                    stock += redisUtils.getSkuStock(vo.getMixId(), skuId);
                }
            } else {
                stock += redisUtils.getSkuStock(vo.getMixId(), item.getSkuId());
            }
        }
        if (stock == 0) {
            vo.setStatus(8);
        } else {
            LocalDateTime nt = LocalDateTime.now();
            LocalDateTime st = LocalDateTime.parse(vo.getTimeStart(), DTF_YMD_HMS);
            LocalDateTime et = LocalDateTime.parse(vo.getTimeEnd(), DTF_YMD_HMS);
            if (nt.isBefore(st)) {
                vo.setStatus(9);
            } else if (nt.isAfter(et)) {
                vo.setStatus(10);
            } else {
                vo.setStatus(6);
            }
        }
        return ResponseDto.success(vo);
    }

    @Override
    public ResponseDto<List<GoblinMixDetailsItemVo>> getItem(String mixId) {
        GoblinMixDetailsVo baseVo = redisUtils.getMixDetails(mixId);
        for (GoblinMixDetailsItemVo item : baseVo.getItem()) {
            item.setStock(0);
        }
        return ResponseDto.success(baseVo.getItem());
    }
}
