package com.liquidnet.client.admin.web.controller.zhengzai.candy;

import com.liquidnet.client.admin.common.annotation.Log;
import com.liquidnet.client.admin.common.core.controller.BaseController;
import com.liquidnet.client.admin.common.core.domain.AjaxResult;
import com.liquidnet.client.admin.common.core.page.TableDataInfo;
import com.liquidnet.client.admin.common.enums.BusinessType;
import com.liquidnet.client.admin.common.utils.DateUtils;
import com.liquidnet.client.admin.common.utils.ShiroUtils;
import com.liquidnet.client.admin.zhengzai.candy.service.ICandyCouponAdminService;
import com.liquidnet.client.admin.zhengzai.candy.service.ICandyMgtCouponAdminService;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.service.candy.dto.admin.CandyMgtCouponBuildParam;
import com.liquidnet.service.candy.dto.admin.CandyMgtCouponInfoDto;
import com.liquidnet.service.candy.dto.admin.CandyMgtCouponListParam;
import com.liquidnet.service.candy.entity.CandyCoupon;
import com.liquidnet.service.candy.entity.CandyMgtCoupon;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

@Api(tags = "券发放管理")
@Controller
@RequestMapping("candy/coupon4/mgt")
public class CandyMgtCoupon4AdminController extends BaseController {
    private final String prefix = "zhengzai/candy/coupon/mgt";
    @Autowired
    private ICandyMgtCouponAdminService candyMgtCouponAdminService;
    @Autowired
    private ICandyCouponAdminService candyCouponAdminService;

    @RequiresPermissions("candy:coupon4:mgt:view")
    @GetMapping()
    public String coupon() {
        return prefix + "/coupon4";
    }

    @RequiresPermissions("candy:coupon4:mgt:list")
    @PostMapping("list")
    @ResponseBody
    public TableDataInfo list(CandyMgtCouponListParam listParam) {
        listParam.setCouType(4);
        startPage();
        List<CandyMgtCouponInfoDto> list = candyMgtCouponAdminService.listForMgtCouponInfoDto(listParam);
        return getDataTable(list);
    }

    @GetMapping("add")
    public String add() {
        return prefix + "/add4";
    }

    @ApiOperation(value = "新建券")
    @RequiresPermissions("candy:coupon4:mgt:add")
    @Log(title = "券发放管理", businessType = BusinessType.INSERT)
    @PostMapping("add")
    @ResponseBody
    public AjaxResult addSave(@Validated CandyMgtCouponBuildParam buildParam) {
        BigDecimal discount = null, valFace = null, valOver = null, valMinus = null;
        Integer couType = buildParam.getCouType(),
                validity = buildParam.getValidity(),
                redeemValidity = buildParam.getRedeemValidity();
        LocalDateTime nowTime = LocalDateTime.now(),
                redeemStart = null, redeemStop = null, effectAt, expireAt,
                eventAt = LocalDateTime.parse(buildParam.getEventAt(), DateTimeFormatter.ofPattern(DateUtils.YYYY_MM_DD_HH_MM_SS));

        switch (couType) {// TODO: 2021/8/20 校验
            case 1:// 代金券
                valFace = buildParam.getValFace();
                break;
            case 2:// 满减券
                valOver = buildParam.getValOver();
                valMinus = buildParam.getValMinus();
                break;
            case 3:// 兑换券
                redeemStart = eventAt.with(LocalTime.MIN);
                redeemStop = eventAt.plusDays(redeemValidity).withHour(23).withMinute(59).withSecond(59);
                break;
            case 4:// 折扣券
                discount = buildParam.getDiscount();
                break;
            default:
                logger.warn("Invalid operation[buildParam.couType={}]", couType);
                return this.error(AjaxResult.Type.WARN, "券类型无效");
        }
        effectAt = eventAt.with(LocalTime.MIN);
        expireAt = eventAt.plusDays(validity).withHour(23).withMinute(59).withSecond(59);

        String eventLimit = null, operator = ShiroUtils.getLoginName();
        if (buildParam.getEventType() == 2) {// 指定用户手机号
            eventLimit = buildParam.getEventLimit().trim();
            // TODO: 2021/8/20 正则校验手机号字符串
            if (StringUtils.isEmpty(eventLimit)) {
                return this.error(AjaxResult.Type.WARN, "请指定手机号");
            }
        }

        CandyCoupon initCoupon = new CandyCoupon();
        initCoupon.setCouponId(IDGenerator.nextMilliId());
        initCoupon.setState(1);
        initCoupon.setTitle(buildParam.getTitle());
        initCoupon.setLabel(buildParam.getLabel());
        initCoupon.setNotice(buildParam.getNotice());
        initCoupon.setExclusive(0);
        initCoupon.setBusiType(buildParam.getBusiType());
        initCoupon.setCouType(couType);
        initCoupon.setBindType(buildParam.getBindType());
        initCoupon.setDiscount(discount);
        initCoupon.setValFace(valFace);
        initCoupon.setValOver(valOver);
        initCoupon.setValMinus(valMinus);
        initCoupon.setOverlay(buildParam.getOverlay());
        initCoupon.setValidity(validity);
        initCoupon.setRedeemValidity(redeemValidity);
        initCoupon.setRedeemStart(redeemStart);
        initCoupon.setRedeemStop(redeemStop);
        initCoupon.setEffectAt(effectAt);
        initCoupon.setExpireAt(expireAt);
        initCoupon.setOperator(operator);
        initCoupon.setCreatedAt(nowTime);

        CandyMgtCoupon initMgtCoupon = new CandyMgtCoupon();
        initMgtCoupon.setMcouponId(IDGenerator.nextMilliId());
        initMgtCoupon.setCouponId(initCoupon.getCouponId());
        initMgtCoupon.setState(0);
        initMgtCoupon.setEventAmt(buildParam.getEventAmt());
        initMgtCoupon.setEventType(buildParam.getEventType());
        initMgtCoupon.setEventLimit(eventLimit);
        initMgtCoupon.setEventAt(eventAt);
        initMgtCoupon.setOperator(operator);
        initMgtCoupon.setCreatedAt(nowTime);

        candyMgtCouponAdminService.saveMgtCouponInfo(initCoupon, initMgtCoupon);

        return toAjax(true);
    }

    @GetMapping("code/{couponId}")
    public String code(@PathVariable("couponId") String couponId, ModelMap mmap) {
        mmap.put("couponId", couponId);
        return prefix + "/code";
    }

    @RequiresPermissions("candy:coupon4:mgt:code:list")
    @PostMapping("codeList")
    @ResponseBody
    public TableDataInfo codeList(CandyMgtCouponListParam listParam) {
        startPage();
        return getDataTable(null);
    }
}
