package com.liquidnet.service.kylin.entity;

import java.math.BigDecimal;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;

import java.time.LocalDateTime;
import java.io.Serializable;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 订单退款表
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-05-26
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class KylinOrderRefunds implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Integer mid;

    /**
     * order_refunds_id
     */
    private String orderRefundsId;

    /**
     * 演出 id
     */
    private String performanceId;

    /**
     * 商户id
     */
    private String merchantId;

    /**
     * 票务订单id
     */
    private String orderId;

    /**
     * 商品订单id
     */
    private String matterId;

    /**
     * 管理员id
     */
    private String adminId;

    /**
     * 管理员名称
     */
    private String adminName;

    /**
     * 退款原因
     */
    private String reason;

    /**
     * 批次从1开始
     */
    private Integer batch;

    /**
     * 下单方式
     */
    private String orderType;

    /**
     * 选择支付方式
     */
    private String payType;

    /**
     * 实际支付方式
     */
    private String paymentType;

    /**
     * 订单入场人/搭售款式表
     */
    private String refundTable;

    /**
     * 票务/商品/快递费
     */
    private String refundType;

    /**
     * 订单入场人/搭售款式表 id
     */
    private String refundTableId;

    /**
     * 演出/商品 id
     */
    private String refundTypeParentId;

    /**
     * 票种/款式 id
     */
    private String refundTypeId;

    /**
     * 2关闭或者取消退款3正在退款,4已退款
     */
    private Integer refundStatus;

    /**
     * 数量
     */
    private Integer refundNumber;

    /**
     * 退款金额 快递费有可能为负,意思是补差价
     */
    private BigDecimal refundPrice;

    /**
     * 使用了兑换券/优惠券/无使用
     */
    private String couponType;

    /**
     * 优惠券id
     */
    private String couponId;

    private LocalDateTime createdAt;

    private LocalDateTime updatedAt;

    /**
     * 退款备注
     */
    private String refundRemark;

    /**
     * 退款单号
     */
    private String refundCode;

    /**
     * 退款表refunds的id
     */
    private String refundId;


}
