/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.api.internal.tmc;

import com.taobao.api.internal.tmc.Message;
import com.taobao.api.internal.tmc.MessageKind;
import com.taobao.api.internal.tmc.MessageStatus;
import com.taobao.api.internal.tmc.TmcClient;
import com.taobao.api.internal.toplink.LinkException;
import com.taobao.api.internal.toplink.endpoint.EndpointBaseContext;
import com.taobao.api.internal.toplink.endpoint.EndpointContext;
import com.taobao.api.internal.toplink.endpoint.MessageHandler;
import com.taobao.api.internal.toplink.util.GZIPHelper;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.RejectedExecutionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TmcHandler
implements MessageHandler {
    private static final Log log = LogFactory.getLog((String)"tmcClient");
    protected TmcClient tmcClient;
    protected volatile boolean stopped;

    public TmcHandler(TmcClient tmcClient) {
        this.tmcClient = tmcClient;
    }

    @Override
    public final void onAckMessage(EndpointBaseContext context) {
    }

    @Override
    public void onMessage(EndpointContext context) throws Exception {
        Map<String, Object> rawMsg = context.getMessage();
        this.handleMessage(this.parse(rawMsg), false);
    }

    public void close() {
        this.stopped = true;
    }

    public void handleConfirm(Message message) {
        this.handleConfirm((Long)message.getRaw().get("id"));
    }

    public void handleConfirm(Long outGoingId) {
        if (this.tmcClient.getConfirmThreadPool() != null) {
            this.tmcClient.getConfirmThreadPool().submit(new ConfirmWorker(0, outGoingId){

                public void run() {
                    try {
                        TmcHandler.this.confirm(this.getOutGoingId());
                    }
                    catch (LinkException e) {
                        log.warn((Object)String.format("confirm message fail: %d", this.getOutGoingId()), (Throwable)e);
                        TmcHandler.this.holdTheThread();
                        if (this.getRetry() < 3) {
                            this.incrRetry();
                            TmcHandler.this.tmcClient.getConfirmThreadPool().submit(this);
                        }
                        log.warn((Object)String.format("confirm message fail 3 times,discard it : %d", this.getOutGoingId()));
                    }
                }
            });
        }
    }

    private void holdTheThread() {
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void retryMessage(final Message message) throws RejectedExecutionException {
        this.tmcClient.getThreadPool().submit(new Runnable(){

            public void run() {
                MessageStatus status = new MessageStatus();
                try {
                    TmcHandler.this.tmcClient.getMessageHandler().onMessage(message, status);
                }
                catch (Exception e) {
                    log.error((Object)String.format("handle message fail: %s", message.getRaw()), (Throwable)e);
                    String errorMsg = e.getMessage();
                    status.fail(errorMsg.substring(0, errorMsg.length() > 128 ? 128 : errorMsg.length()));
                }
                if (!TmcHandler.this.tmcClient.isUseDefaultConfirm()) {
                    return;
                }
                if (!status.isFail()) {
                    try {
                        TmcHandler.this.confirm(message.getId());
                    }
                    catch (Exception e) {
                        log.warn((Object)String.format("confirm message fail: %s", message.getRaw()), (Throwable)e);
                    }
                }
            }
        });
    }

    public void handleMessage(final Message message, final boolean ignore) {
        log.info((Object)String.format("receive message topic:%s, dataid: %s", message.getTopic(), message.getDataId()));
        while (!this.stopped) {
            try {
                this.tmcClient.getThreadPool().submit(new Runnable(){

                    public void run() {
                        MessageStatus status = new MessageStatus();
                        long begin = System.currentTimeMillis();
                        if (!ignore) {
                            try {
                                TmcHandler.this.tmcClient.getMessageHandler().onMessage(message, status);
                            }
                            catch (Exception e) {
                                log.error((Object)String.format("handle message fail topic:%s, dataid: %s", message.getTopic(), message.getDataId()), (Throwable)e);
                                String errorMsg = e.getMessage();
                                status.fail(errorMsg.substring(0, errorMsg.length() > 128 ? 128 : errorMsg.length()));
                            }
                        }
                        if (!TmcHandler.this.tmcClient.isUseDefaultConfirm()) {
                            status.fail();
                        }
                        try {
                            if (ignore || !status.isFail()) {
                                long end = System.currentTimeMillis();
                                TmcHandler.this.confirm(message.getId());
                                log.info((Object)String.format("handle message success topic:%s, dataid: %s. total spent %s ,local spent %s", message.getTopic(), message.getDataId(), message.getOutgoingTime() == null ? 0L : end - message.getOutgoingTime().getTime(), end - begin));
                            }
                            if (status.isFail()) {
                                TmcHandler.this.fail(message.getId(), status.getReason());
                            }
                        }
                        catch (Exception e) {
                            log.warn((Object)String.format("confirm message fail: %s", message.getRaw()), (Throwable)e);
                        }
                    }
                });
                break;
            }
            catch (RejectedExecutionException ree) {
                log.warn((Object)String.format("all tmc worker threads are currently busy, waiting 50 ms, appkey:%s-group:%s", this.tmcClient.getAppKey(), this.tmcClient.getGroupName()));
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    protected void confirm(Map<String, Object> message) throws LinkException {
        this.confirm((Long)message.get("id"));
    }

    protected void confirm(Long outGoingId) throws LinkException {
        HashMap<String, Object> msg = new HashMap<String, Object>();
        msg.put("__kind", MessageKind.Confirm);
        msg.put("id", outGoingId);
        this.tmcClient.getClient().send(msg);
    }

    protected void fail(Long outGoingId, String errorMsg) throws LinkException {
        HashMap<String, Object> msg = new HashMap<String, Object>();
        msg.put("__kind", MessageKind.Failed);
        msg.put("id", outGoingId);
        msg.put("msg", errorMsg);
        this.tmcClient.getClient().send(msg);
    }

    protected Message parse(Map<String, Object> raw) throws IOException {
        Object content;
        Object time;
        Message msg = new Message();
        msg.setRaw(raw);
        msg.setId((Long)raw.get("id"));
        msg.setTopic((String)raw.get("topic"));
        msg.setPubAppKey((String)raw.get("publisher"));
        msg.setUserId((Long)raw.get("userid"));
        msg.setUserNick((String)raw.get("nick"));
        msg.setPubTime((Date)raw.get("time"));
        Object dataId = raw.get("dataid");
        if (dataId != null) {
            msg.setDataId(dataId.toString());
        }
        if ((time = raw.get("outtime")) != null) {
            msg.setOutgoingTime((Date)time);
        }
        if ((content = raw.get("content")) instanceof String) {
            msg.setContent((String)content);
        } else if (content instanceof byte[]) {
            msg.setContent(new String(GZIPHelper.unzip((byte[])content), "UTF-8"));
        }
        return msg;
    }

    public abstract class ConfirmWorker
    implements Runnable {
        private int retry;
        private final Long outGoingId;

        public ConfirmWorker(int retry, Long outGoingId) {
            this.retry = retry;
            this.outGoingId = outGoingId;
        }

        public void incrRetry() {
            ++this.retry;
        }

        public int getRetry() {
            return this.retry;
        }

        public Long getOutGoingId() {
            return this.outGoingId;
        }
    }
}

