package com.liquidnet.service.bank.currencycloud.dto;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;
import java.util.List;

@Data
@ApiModel
public class BankCcBeneficiaryParam {
    // 该字段是自定义,方便打印日志
    private String uniqueRequestId;

    private String id;
    private String bankAccountHolderName;
    private String name;
    private String email;
    private Boolean defaultBeneficiary;
    private String creatorContactId;
    private Date createdAt;
    private Date updatedAt;
    private List<String> paymentTypes;
    private String bankCountry;
    private String bankName;
    private String currency;
    private String accountNumber;
    private String bankAccountType;
    private List<String> beneficiaryAddress;
    private String beneficiaryCountry;
    private String beneficiaryEntityType;
    private String beneficiaryCompanyName;
    private String beneficiaryFirstName;
    private String beneficiaryLastName;
    private String beneficiaryCity;
    private String beneficiaryPostcode;
    private String beneficiaryStateOrProvince;
    private Date beneficiaryDateOfBirth;
    private String beneficiaryIdentificationType;
    private String beneficiaryIdentificationValue;
    private String beneficiaryExternalReference;
    @JsonProperty("routing_code_type_1")
    private String routingCodeType1;
    @JsonProperty("routing_code_value_1")
    private String routingCodeValue1;
    @JsonProperty("routing_code_type_2")
    private String routingCodeType2;
    @JsonProperty("routing_code_value_2")
    private String routingCodeValue2;
    private String bicSwift;
    private String iban;
    private List<String> bankAddress;
    private String scope;
}
