package com.liquidnet.service.kylin.dto.param.admin;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * <p>
 * 友盟推送 search param
 * </p>
 * @author jiangxiulong
 * @since 2021-07-13
 */

@Data
public class UpushSearchParam implements Serializable {

    @ApiModelProperty(value = "页数", example = "0")
    @NotNull(message = "页数不能为空")
    private Integer pageSize;

    @ApiModelProperty(value = "数量", example = "20")
    @NotNull(message = "数量不能为空")
    private Integer pageNum;

    private String pushTitle;
    /**
     * 推送设备all ios android
     */
    private Integer pushRange;

    /**
     * 用户类型
     */
    private Integer specifyType;

    /**
     * 跳转类型
     */
    private Integer jumpType;

    /**
     * 是否发送推送消息，2不发送 1发送推送消息
     */
    private Integer isPush;

    /**
     * 消息类型，2系统消息 1会员消息
     */
    private Integer messageType;

}
