package com.liquidnet.service.stone.service.impl;

import com.github.pagehelper.PageInfo;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.stone.entity.StoneScoreItems;
import com.liquidnet.service.stone.service.IStoneScoreOrderService;
import com.liquidnet.service.stone.util.StoneRedisUtils;
import com.liquidnet.service.stone.vo.StoneItemListVo;
import com.liquidnet.service.stone.vo.StoneOrderListVo;
import com.liquidnet.service.stone.vo.StoneScoreItemVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <p>
 * 积分订单表 服务实现类
 * </p>
 *
 * @author liquidnet
 * @since 2021-10-19
 */
@Service
public class StoneScoreOrderServiceImpl implements IStoneScoreOrderService {

    @Autowired
    StoneRedisUtils stoneRedisUtils;

    @Override
    public ResponseDto<String> order(String itemId, Integer number) {
        //判断状态 库存
        StoneScoreItems data = stoneRedisUtils.getItemData(itemId);
        if(data==null){
            return ResponseDto.failure("参数异常");
        }
        if(stoneRedisUtils.getStoneGeneralSurplus(itemId)<=0){
            return ResponseDto.failure("该商品库存不足");
        }
        StoneScoreItemVo vo = StoneScoreItemVo.getNew().copy(data);
        if(vo.getStatus()!=1){
            return ResponseDto.failure("该商品不可下单");
        }

        //获取积分
        //获取限购
        //下单
        return null;
    }

    @Override
    public ResponseDto<PageInfo<List<StoneOrderListVo>>> orderList(Integer page) {
        return null;
    }
}
