package com.liquidnet.service.sweet.controller;

import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.sweet.constant.SweetConstant;
import com.liquidnet.service.sweet.mapper.SweetAnswerMapper;
import com.liquidnet.service.sweet.service.impl.SweetWechatLoginServiceImpl;
import com.liquidnet.service.sweet.vo.SweetUserTempVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@Api(tags = "数据迁移")
@RestController
@RequestMapping("/sweetData")
public class SweetDataController {

    @Autowired
    private SweetAnswerMapper sweetAnswerMapper;
    @Autowired
    private RedisUtil redisUtil;

    @GetMapping("drawLuck")
    @ApiOperation("中奖概率迁移")
    public ResponseDto<String> drawLuck() {
        try {
            List<SweetUserTempVo> listHPFD = sweetAnswerMapper.selectHPFD();
            List<SweetUserTempVo> listHPWR = sweetAnswerMapper.selectHPWR();
            List<SweetUserTempVo> listHXC = sweetAnswerMapper.selectHXC();
            List<SweetUserTempVo> listMember = sweetAnswerMapper.selectMember();
            List<SweetUserTempVo> listOrder1 = sweetAnswerMapper.selectOrder1();
            List<SweetUserTempVo> listOrder2 = sweetAnswerMapper.selectOrder2();
            List<SweetUserTempVo> listOrder3 = sweetAnswerMapper.selectOrder3();

            for (SweetUserTempVo item : listHPFD) {
                presentRedis(item.getMobile());
            }

            for (SweetUserTempVo item : listHPWR) {
                presentRedis(item.getMobile());
            }

            for (SweetUserTempVo item : listHXC) {
                presentRedis(item.getMobile());
            }

            for (SweetUserTempVo item : listMember) {
                presentRedis(item.getMobile());
            }

            for (SweetUserTempVo item : listOrder1) {
                presentRedis(item.getMobile());
            }

            for (SweetUserTempVo item : listOrder2) {
                presentRedis(item.getMobile());
            }

            for (SweetUserTempVo item : listOrder3) {
                presentRedis(item.getMobile());
            }

            return ResponseDto.success();
        } catch (Exception e) {
            e.printStackTrace();
            return ResponseDto.failure();
        }
    }

    private void presentRedis(String mobile) {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_LUCK_DRAW_PRESENT_MOBILE.concat(mobile);
        Object obj = redisUtil.get(redisKey);
        if (obj == null) {
            redisUtil.set(redisKey, 20);
        } else {
            redisUtil.incr(redisKey, 10);
        }
    }

}
