package com.liquidnet.service.order.service.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import com.liquidnet.commons.lang.util.*;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.goblin.dto.vo.GoblinGoodsSkuInfoVo;
import com.liquidnet.service.goblin.dto.vo.GoblinNftOrderVo;
import com.liquidnet.service.goblin.dto.vo.GoblinPayInnerResultVo;
import com.liquidnet.service.goblin.param.GoblinNftOrderPayCallbackParam;
import com.liquidnet.service.order.utils.GoblinNftOrderUtils;
import com.liquidnet.service.order.utils.GoblinRedisUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

@Service
@Slf4j
public class OrderApplePayServiceImpl {

    @Autowired
    GoblinRedisUtils goblinRedisUtils;
    @Autowired
    GoblinNftOrderUtils nftOrderUtils;

    @Autowired
    private GoblinNftOrderServiceImpl goblinNftOrderService;

    @Value("${liquidnet.service.order.url-pay.pay}")
    private String payUrl;

    public boolean pay(String orderId, String type, String receiptData) {
        log.info("苹果支付成功通知参数 [orderId:{},type:{},receiptData:{}]", orderId, type, receiptData);
        GoblinNftOrderVo nftOrder = nftOrderUtils.getNftOrder(orderId);
        if (null == nftOrder) {
            log.info("未找到该订单 [orderId:{}]", orderId);
            return false;
        }
        LinkedMultiValueMap<String, String> httpData = CollectionUtil.linkedMultiValueMapStringString();
        httpData.add("type", type);
        httpData.add("price", nftOrder.getPriceActual().toString());
        httpData.add("name", nftOrder.getStoreName());
        GoblinGoodsSkuInfoVo skuVo = goblinRedisUtils.getGoodsSkuInfoVo(nftOrder.getSkuId());
        httpData.add("detail", skuVo.getName());
        httpData.add("orderCode", nftOrder.getOrderCode());
        httpData.add("orderId", nftOrder.getOrderId());
        httpData.add("clientIp", CurrentUtil.getCliIpAddr());
        httpData.add("notifyUrl", "");
        httpData.add("createDate", LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        httpData.add("expireTime", "5");
        httpData.add("payType", nftOrder.getPayType());
        httpData.add("deviceFrom", nftOrder.getDeviceFrom());
        httpData.add("openId", "");
        httpData.add("showUrl", "");
        httpData.add("returnUrl", "");
        httpData.add("receiptData", receiptData);

        LinkedMultiValueMap<String, String> header = CollectionUtil.linkedMultiValueMapStringString();
        header.add("Accept", "application/json;charset=UTF-8");
        String returnData = HttpUtil.post(payUrl, httpData, header);
        log.info("苹果支付调用DRAGON结果 = " + returnData);
        ResponseDto<GoblinPayInnerResultVo> dto = JsonUtils.fromJson(returnData, new TypeReference<ResponseDto<GoblinPayInnerResultVo>>() {
        });
        GoblinPayInnerResultVo dtoData = dto.getData();
        if (null == dtoData || dtoData.getStatus() == 0) {
            return false;
        } else {
            // 支付成功
            GoblinNftOrderPayCallbackParam NftOrderPayCallbackParam = GoblinNftOrderPayCallbackParam.getNew();
            NftOrderPayCallbackParam.setCode(nftOrder.getPayCode());
            NftOrderPayCallbackParam.setOrderCode(nftOrder.getOrderCode());
            NftOrderPayCallbackParam.setPaymentAt(DateUtil.format(LocalDateTime.now(), DateUtil.Formatter.yyyyMMddHHmmss));
            NftOrderPayCallbackParam.setPrice(nftOrder.getPriceActual());
            NftOrderPayCallbackParam.setPaymentId("APPLE_PAYMENT_ID");// 这里应该是接口返回
            NftOrderPayCallbackParam.setPaymentType("APPLE_PAY");// 这里应该是接口返回
            NftOrderPayCallbackParam.setStatus(1);
            if (type.equals("NFT")) {
                String isSync = goblinNftOrderService.syncOrder(NftOrderPayCallbackParam);
                if (!isSync.equals("success")) {
                    return false;
                }
            }
            return true;
        }
    }
}
