package com.liquidnet.service.goblin.dto.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.service.goblin.dto.manage.vo.GoblinGoodsAnticipateValueVo;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 * 预约表
 * </p>
 *
 * @author liquidnet
 * @since 2022-04-07
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class GoblinGoodsAnticipateVo implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * id
     */
    private String id;

    /**
     * ant_id
     */
    private String antId;

    /**
     * 预约名称
     */
    @ApiModelProperty(value = "预约名称")
    private String name;

    /**
     * 预约规则
     */
    @ApiModelProperty(value = "预约规则")
    private String rule;

    /**
     * 预约人数
     */
    @ApiModelProperty(value = "预约人数")
    private Long aboutPeople;

    /**
     * 预约人数
     */
    @ApiModelProperty(value = "实际预约人数")
    private Long actualPeople;

    /**
     * 预约开始时间
     */
    @ApiModelProperty(value = "预约开始时间")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DateUtil.DATE_FULL_STR)
    private LocalDateTime aboutStartDate;

    /**
     * 预约结束时间
     */
    @ApiModelProperty(value = "预约结束时间")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DateUtil.DATE_FULL_STR)
    private LocalDateTime aboutEndDate;

    /**
     * 创建时间
     */
    @ApiModelProperty(value = "创建时间")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DateUtil.DATE_FULL_STR)
    private LocalDateTime createdDate;

    /**
     * 修改时间
     */
    @ApiModelProperty(value = "修改时间")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DateUtil.DATE_FULL_STR)
    private LocalDateTime updateDate;

    /**
     * 删除（0:未删除1:已删除）
     */
    @ApiModelProperty(value = "删除（0:未删除1:已删除）")
    private Integer delTag;

    @ApiModelProperty(value = "目前三种状态（0:未开始，1:预约中，2:已结束）")
    private Integer state;

}
