package com.liquidnet.service.sweet.controller;


import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.sweet.service.impl.SweetAppletSubMsgServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

/**
 * <p>
 * 小程序订阅消息记录表 前端控制器
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-11-22
 */
@Api(tags = "小程序-订阅消息")
@Slf4j
@Validated
@RestController
@RequestMapping("/appletSubMsg")
public class SweetAppletSubMsgController {

    @Autowired
    private SweetAppletSubMsgServiceImpl subMsgService;

    @GetMapping("send")
    @ApiOperation("发送模版消息")
    public ResponseDto send() {
        return subMsgService.sendMsg();
    }


}
