package com.liquidnet.service.consumer.sweet.config;

import com.liquidnet.common.cache.redis.config.RedisStreamConfig;
import com.liquidnet.service.base.constant.MQConst;
import com.liquidnet.service.consumer.sweet.receiver.ConsumerSweetStoneIntegralReceiver;
import com.liquidnet.service.consumer.sweet.receiver.ConsumerSweetTemplateMsgReceiver;
import lombok.var;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.stream.Consumer;
import org.springframework.data.redis.connection.stream.MapRecord;
import org.springframework.data.redis.connection.stream.ReadOffset;
import org.springframework.data.redis.connection.stream.StreamOffset;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.stream.StreamMessageListenerContainer;
import org.springframework.data.redis.stream.Subscription;

import java.util.ArrayList;
import java.util.List;

import static com.liquidnet.service.base.constant.MQConst.SweetQueue.SWEET_TEMPLATE_MSG;
import static com.liquidnet.service.base.constant.MQConst.SweetQueue.SWEET_STONE_INTEGRAL;

@Configuration
public class ConsumerSweetOtherApiStreamConfig extends RedisStreamConfig {
    @Autowired
    ConsumerSweetTemplateMsgReceiver consumerSweetTemplateMsgReceiver;
    @Autowired
    ConsumerSweetStoneIntegralReceiver consumerSweetStoneIntegralReceiver;
    @Autowired
    StringRedisTemplate stringRedisTemplate;

    @Bean
    public List<Subscription> subscriptionSqlSTM(RedisConnectionFactory factory) {
        List<Subscription> subscriptionList = new ArrayList<>();
        MQConst.SweetQueue stream = MQConst.SweetQueue.SWEET_TEMPLATE_MSG;
        this.initStream(stringRedisTemplate, stream.getKey(), stream.getGroup());
        for (int i = 0; i < 3; i++) {
            StreamMessageListenerContainer<String, MapRecord<String, String, String>> listenerContainer = this.buildStreamMessageListenerContainer(factory);
            subscriptionList.add(listenerContainer.receiveAutoAck(
                    Consumer.from(stream.getGroup(), getConsumerName(stream.name() + i)),
                    StreamOffset.create(stream.getKey(), ReadOffset.lastConsumed()), consumerSweetTemplateMsgReceiver
            ));
            listenerContainer.start();
        }
        return subscriptionList;
    }

    @Bean
    public List<Subscription> subscriptionSql2(RedisConnectionFactory factory) {
        List<Subscription> subscriptionList = new ArrayList<>();
        MQConst.SweetQueue stream = MQConst.SweetQueue.SWEET_STONE_INTEGRAL;
        this.initStream(stringRedisTemplate, stream.getKey(), stream.getGroup());
        for (int i = 0; i < 3; i++) {
            StreamMessageListenerContainer<String, MapRecord<String, String, String>> listenerContainer = this.buildStreamMessageListenerContainer(factory);
            subscriptionList.add(listenerContainer.receiveAutoAck(
                    Consumer.from(stream.getGroup(), getConsumerName(stream.name() + i)),
                    StreamOffset.create(stream.getKey(), ReadOffset.lastConsumed()), consumerSweetStoneIntegralReceiver
            ));
            listenerContainer.start();
        }
        return subscriptionList;
    }
//    /**
//     * 模版消息
//     */
//    private Subscription receiveApiTemplateMsg(StreamMessageListenerContainer<String, MapRecord<String, String, String>> listenerContainer, int t) {
//        return listenerContainer.receiveAutoAck(Consumer.from(SWEET_TEMPLATE_MSG.getGroup(), getConsumerName(SWEET_TEMPLATE_MSG.name() + t)),
//                StreamOffset.create(SWEET_TEMPLATE_MSG.getKey(), ReadOffset.lastConsumed()), consumerSweetTemplateMsgReceiver);
//    }
//    /**
//     * 增减积分
//     */
//    private Subscription receiveApiStoneIntgral(StreamMessageListenerContainer<String, MapRecord<String, String, String>> listenerContainer, int t) {
//        return listenerContainer.receiveAutoAck(Consumer.from(SWEET_STONE_INTEGRAL.getGroup(), getConsumerName(SWEET_STONE_INTEGRAL.name() + t)),
//                StreamOffset.create(SWEET_STONE_INTEGRAL.getKey(), ReadOffset.lastConsumed()), consumerSweetStoneIntegralReceiver);
//    }
//
//    /*----------------------------------------------------------------------------------------------------------------*/
//
//    /*------------------模版消息------------------*/
//
//    @Bean
//    public Subscription subscriptionApiTemplateMsg0(RedisConnectionFactory factory) {
//        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
//        var subscription = receiveApiTemplateMsg(listenerContainer, 0);
//        listenerContainer.start();
//        return subscription;
//    }
//
//    @Bean
//    public Subscription subscriptionApiTemplateMsg1(RedisConnectionFactory factory) {
//        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
//        var subscription = receiveApiTemplateMsg(listenerContainer, 1);
//        listenerContainer.start();
//        return subscription;
//    }
//
//    @Bean
//    public Subscription subscriptionApiTemplateMsg2(RedisConnectionFactory factory) {
//        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
//        var subscription = receiveApiTemplateMsg(listenerContainer, 2);
//        listenerContainer.start();
//        return subscription;
//    }
//
//    /*------------------增减积分------------------*/
//
//    @Bean
//    public Subscription subscriptionApiStoneIntgral0(RedisConnectionFactory factory) {
//        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
//        var subscription = receiveApiStoneIntgral(listenerContainer, 0);
//        listenerContainer.start();
//        return subscription;
//    }
//
//    @Bean
//    public Subscription subscriptionApiStoneIntgral1(RedisConnectionFactory factory) {
//        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
//        var subscription = receiveApiStoneIntgral(listenerContainer, 1);
//        listenerContainer.start();
//        return subscription;
//    }
//
//    @Bean
//    public Subscription subscriptionApiStoneIntgral2(RedisConnectionFactory factory) {
//        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
//        var subscription = receiveApiStoneIntgral(listenerContainer, 2);
//        listenerContainer.start();
//        return subscription;
//    }

    /*------------------  ------------------*/
}
