package com.liquidnet.service.slime.dto.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.liquidnet.commons.lang.util.DateUtil;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;

@ApiModel(value = "SlimeFieldsVo", description = "App场地详情")
@Data
public class SlimeFieldsDetailsVo implements java.io.Serializable, Cloneable {
    private static final long serialVersionUID = 2531062739435013044L;

    @ApiModelProperty(position = 11, value = "场地ID")
    private String fieldId;
    @ApiModelProperty(position = 16, value = "场地名称[30]")
    private String name;
    @ApiModelProperty(position = 17, value = "logo图")
    private String logo;
    @ApiModelProperty(position = 18, value = "背景图")
    private String background;
    @ApiModelProperty(position = 19, value = "介绍[1000]")
    private String description;
    @ApiModelProperty(position = 21, value = "省id")
    private String provinceId;
    @ApiModelProperty(position = 22, value = "省名称")
    private String provinceName;
    @ApiModelProperty(position = 23, value = "城市id")
    private String cityId;
    @ApiModelProperty(position = 24, value = "城市名称")
    private String cityName;
    @ApiModelProperty(position = 25, value = "县id")
    private String districtId;
    @ApiModelProperty(position = 26, value = "县名称")
    private String districtName;
    @ApiModelProperty(position = 27, value = "详细地址[100]")
    private String address;
    @ApiModelProperty(position = 28, value = "经度")
    private String longitude;
    @ApiModelProperty(position = 29, value = "纬度")
    private String latitude;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DateUtil.DATE_FULL_STR)
    private LocalDateTime createdAt;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DateUtil.DATE_FULL_STR)
    private LocalDateTime updatedAt;


    private static final SlimeFieldsDetailsVo obj = new SlimeFieldsDetailsVo();

    public static SlimeFieldsDetailsVo getNew() {
        try {
            return (SlimeFieldsDetailsVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return new SlimeFieldsDetailsVo();
    }

}
