package com.liquidnet.service.adam.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.liquidnet.common.mq.constant.MQConst;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.service.adam.dto.AdamThirdPartParam;
import com.liquidnet.service.adam.dto.vo.*;
import com.liquidnet.service.adam.entity.AdamAddresses;
import com.liquidnet.service.adam.entity.AdamEnters;
import com.liquidnet.service.adam.entity.AdamRealName;
import com.liquidnet.service.adam.entity.AdamUser;
import com.liquidnet.service.adam.mapper.AdamUserMapper;
import com.liquidnet.service.adam.service.*;
import com.liquidnet.service.base.SqlMapping;
import com.mongodb.BasicDBObject;
import com.mongodb.client.model.FindOneAndUpdateOptions;
import com.mongodb.client.model.ReturnDocument;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.bson.Document;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

/**
 * <p>
 * 用户 服务实现类
 * </p>
 *
 * @author liquidnet
 * @since 2021-05-10
 */
@Slf4j
@Service
public class AdamUserServiceImpl extends ServiceImpl<AdamUserMapper, AdamUser> implements IAdamUserService {
    @Autowired
    MongoConverter mongoConverter;
    @Autowired
    MongoTemplate mongoTemplate;
    @Autowired
    RabbitTemplate rabbitTemplate;
    @Autowired
    IAdamEntersService adamEntersService;
    @Autowired
    IAdamThirdPartyService adamThirdPartyService;
    @Autowired
    IAdamRealNameService adamRealNameService;
    @Autowired
    IAdamRdmService adamRdmService;

//    @Override
//    public AdamUserInfoVo queryByUid(String uid) {
//        AdamUserInfoVo userInfoVo = (AdamUserInfoVo) redisUtil.hget(AdamRedisConst.INFO_USER, uid);
//        if (null == userInfoVo) {
//            userInfoVo = mongoTemplate.findOne(Query.query(Criteria.where("uid").is(uid).and("state").is(1)),
//                    AdamUserInfoVo.class, AdamUserInfoVo.class.getSimpleName());
//
//            if (null != userInfoVo) redisUtil.hset(AdamRedisConst.INFO_USER, uid, userInfoVo);
//        }
//        return userInfoVo;
//    }

//    @Override
//    public String queryUidByRedis(String mobile) {
//        return (String) redisUtil.hget(AdamRedisConst.INFO_IDENTITY_MOBILE, mobile);
//    }
//
//    @Override
//    public String queryUidByRedis(String openId, String platform) {
//        return (String) redisUtil.hget(AdamRedisConst.INFO_IDENTITY_THIRD_PARTY, platform.concat(openId));
//    }

    @Override
//    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
    public AdamUserInfoVo register(String mobile) {
        LocalDateTime now = LocalDateTime.now();
        String nowStr = DateUtil.format(now, DateUtil.Formatter.yyyyMMddHHmmss);

        AdamUserInfoVo userInfoVo = AdamUserInfoVo.getNew();
        userInfoVo.setUid(IDGenerator.nextSnowId() + "");
        userInfoVo.setMobile(mobile);
        userInfoVo.setIsComplete(0);
        userInfoVo.setState(1);
        userInfoVo.setQrCode("lN".concat(userInfoVo.getUid()).concat(RandomStringUtils.randomAlphanumeric(5).toUpperCase()));
        userInfoVo.setCreateAt(nowStr);

        mongoTemplate.insert(userInfoVo, AdamUserInfoVo.class.getSimpleName());

        rabbitTemplate.convertAndSend(MQConst.EXCHANGES_LIQUIDNET_SQL, MQConst.ROUTING_KEY_SQL,
                SqlMapping.get("adam_user.add", userInfoVo.getUid(), userInfoVo.getMobile(), userInfoVo.getState(), now)
        );

        adamRdmService.setUidByMobile(mobile, userInfoVo.getUid());

        return userInfoVo;
    }

    @Override
//    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
    public AdamUserInfoVo register(AdamThirdPartParam param) {
        LocalDateTime now = LocalDateTime.now();
        String nowStr = DateUtil.format(now, DateUtil.Formatter.yyyyMMddHHmmss);

        String uid = adamRdmService.getUidByMobile(param.getMobile());
        LinkedList<String> toMqSqls = new LinkedList<>();
        LinkedList<Object[]> initUserObjs = new LinkedList<>(), initThirdPartObjs = new LinkedList<>();
        AdamUserInfoVo userInfoVo;
        if (StringUtils.isEmpty(uid)) {// 手机号未注册
            userInfoVo = AdamUserInfoVo.getNew();

            userInfoVo.setUid(IDGenerator.nextSnowId() + "");
            userInfoVo.setMobile(param.getMobile());
            userInfoVo.setIsComplete(0);
            userInfoVo.setState(1);
            userInfoVo.setQrCode("lN".concat(userInfoVo.getUid()).concat(RandomStringUtils.randomAlphanumeric(5).toUpperCase()));
            userInfoVo.setCreateAt(nowStr);

            mongoTemplate.insert(userInfoVo, AdamUserInfoVo.class.getSimpleName());

            toMqSqls.add(SqlMapping.get("adam_user.add"));
            initUserObjs.add(new Object[]{userInfoVo.getUid(), userInfoVo.getMobile(), userInfoVo.getState(), now});
        } else {
            userInfoVo = adamRdmService.getUserInfoVoByUid(uid);
        }

        AdamThirdPartInfoVo thirdPartInfoVo = AdamThirdPartInfoVo.getNew();
        BeanUtils.copyProperties(param, thirdPartInfoVo);
        thirdPartInfoVo.setCreatedAt(nowStr);
        thirdPartInfoVo.setUid(userInfoVo.getUid());
        thirdPartInfoVo.setState(1);// 1-绑定

        mongoTemplate.insert(thirdPartInfoVo, AdamThirdPartInfoVo.class.getSimpleName());

        toMqSqls.add(SqlMapping.get("adam_third_party.add"));
        initThirdPartObjs.add(new Object[]{thirdPartInfoVo.getUid(), thirdPartInfoVo.getOpenId(), thirdPartInfoVo.getAvatar(), thirdPartInfoVo.getNickname(), thirdPartInfoVo.getPlatform(), thirdPartInfoVo.getState(), thirdPartInfoVo.getCreatedAt()});

        rabbitTemplate.convertAndSend(MQConst.EXCHANGES_LIQUIDNET_SQL, MQConst.ROUTING_KEY_SQL,
                SqlMapping.gets(toMqSqls, initUserObjs, initThirdPartObjs)
        );

        adamRdmService.setUidByPlatformOpenId(param.getPlatform(), param.getOpenId(), uid);

        return userInfoVo;
    }

    @Override
    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
    public void bindTpa(String uid, AdamThirdPartParam param) {
        LocalDateTime now = LocalDateTime.now();
        String nowStr = DateUtil.format(now, DateUtil.Formatter.yyyyMMddHHmmss);

        AdamThirdPartInfoVo thirdPartInfoVo = AdamThirdPartInfoVo.getNew();
        BeanUtils.copyProperties(param, thirdPartInfoVo);
        thirdPartInfoVo.setCreatedAt(nowStr);
        thirdPartInfoVo.setUid(uid);
        thirdPartInfoVo.setState(1);// 1-绑定

        mongoTemplate.insert(thirdPartInfoVo, AdamThirdPartInfoVo.class.getSimpleName());

        adamRdmService.setUidByPlatformOpenId(param.getPlatform(), param.getOpenId(), uid);

        adamRdmService.delThirdPartVoListByUid(uid);

        rabbitTemplate.convertAndSend(MQConst.EXCHANGES_LIQUIDNET_SQL, MQConst.ROUTING_KEY_SQL,
                SqlMapping.get(
                        "adam_third_party.add",
                        thirdPartInfoVo.getUid(), thirdPartInfoVo.getOpenId(), thirdPartInfoVo.getAvatar(), thirdPartInfoVo.getNickname(), thirdPartInfoVo.getPlatform(), thirdPartInfoVo.getState(), thirdPartInfoVo.getCreatedAt()
                )
        );
    }

    @Override
    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
    public void bindTpaForce(String bindUid, String unBindUid, AdamThirdPartParam param) {
        this.unBindTpaProcess(unBindUid, param.getPlatform());

        LocalDateTime now = LocalDateTime.now();
        String nowStr = DateUtil.format(now, DateUtil.Formatter.yyyyMMddHHmmss);

        AdamThirdPartInfoVo thirdPartInfoVo = AdamThirdPartInfoVo.getNew();
        BeanUtils.copyProperties(param, thirdPartInfoVo);
        thirdPartInfoVo.setCreatedAt(nowStr);
        thirdPartInfoVo.setUid(bindUid);
        thirdPartInfoVo.setState(1);// 1-绑定

        mongoTemplate.insert(thirdPartInfoVo, AdamThirdPartInfoVo.class.getSimpleName());

        adamRdmService.setUidByPlatformOpenId(param.getPlatform(), param.getOpenId(), bindUid);

        adamRdmService.delThirdPartVoListByUid(bindUid);

        rabbitTemplate.convertAndSend(MQConst.EXCHANGES_LIQUIDNET_SQL, MQConst.ROUTING_KEY_SQL,
                SqlMapping.get(
                        "adam_third_party.add",
                        thirdPartInfoVo.getUid(), thirdPartInfoVo.getOpenId(), thirdPartInfoVo.getAvatar(), thirdPartInfoVo.getNickname(), thirdPartInfoVo.getPlatform(), thirdPartInfoVo.getState(), thirdPartInfoVo.getCreatedAt()
                )
        );
    }

    /**
     * 解绑第三方账号操作
     *
     * @param uid
     * @param platform
     */
    private void unBindTpaProcess(String uid, String platform) {
        LocalDateTime now = LocalDateTime.now();
        String nowStr = DateUtil.format(now, DateUtil.Formatter.yyyyMMddHHmmss);

        AdamThirdPartInfoVo unBindThirdPartInfoVo = AdamThirdPartInfoVo.getNew();
        unBindThirdPartInfoVo.setUpdatedAt(nowStr);
        unBindThirdPartInfoVo.setState(2);// 2-解绑

        Document doc = mongoTemplate.getCollection(AdamThirdPartInfoVo.class.getSimpleName()).findOneAndUpdate(
                Query.query(Criteria.where("uid").is(uid).and("platform").is(platform).and("state").is(1)).getQueryObject(),
                new BasicDBObject("$set", mongoConverter.convertToMongoType(unBindThirdPartInfoVo)),
                new FindOneAndUpdateOptions().returnDocument(ReturnDocument.AFTER)
        );

        if (null != doc) {
            adamRdmService.delUidByPlatformOpenId(platform, doc.getString("openId"));
        }
        adamRdmService.delThirdPartVoListByUid(uid);

        rabbitTemplate.convertAndSend(MQConst.EXCHANGES_LIQUIDNET_SQL, MQConst.ROUTING_KEY_SQL,
                SqlMapping.get("adam_third_party.unbind", now, uid, platform));
    }

    @Override
    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
    public void unBindTpa(String uid, String platform) {
        this.unBindTpaProcess(uid, platform);
    }

    @Override
    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
    public void close(String uid) {
        LocalDateTime now = LocalDateTime.now();
        String nowStr = DateUtil.format(now, DateUtil.Formatter.yyyyMMddHHmmss);
        LinkedList<String> toMqSqls = new LinkedList<>();
        LinkedList<Object[]> objsUser = new LinkedList<>(),
                objsThirdPart = new LinkedList<>(),
                objsAddresses = new LinkedList<>();

        AdamUserInfoVo userInfoVo = adamRdmService.getUserInfoVoByUid(uid);

        adamRdmService.delUidByMobile(userInfoVo.getMobile());
        List<AdamThirdPartInfoVo> thirdPartInfoVos = adamRdmService.getThirdPartVoListByUid(uid);
        if (!CollectionUtils.isEmpty(thirdPartInfoVos)) {
            thirdPartInfoVos.forEach(r -> {
                adamRdmService.delUidByPlatformOpenId(r.getPlatform(), r.getOpenId());
            });
            adamRdmService.delThirdPartVoListByUid(uid);
        }
        adamRdmService.delUserInfoVoByUid(uid);
        adamRdmService.delUserMemberVoByUid(uid);
        adamRdmService.delAddressesVoByUid(uid);
        adamRdmService.delEntersVoByUid(uid);

        DeleteResult deleteResult = mongoTemplate.remove(Query.query(Criteria.where("uid").is(uid)), AdamUserInfoVo.class.getSimpleName());
        toMqSqls.add(SqlMapping.get("adam_user.close"));
        objsUser.add(new Object[]{now, now, uid});

        /* ---------------------- 三方账号信息 */
        if (!CollectionUtils.isEmpty(thirdPartInfoVos)) {
            mongoTemplate.remove(Query.query(Criteria.where("uid").is(uid)), AdamThirdPartInfoVo.class.getSimpleName());
            toMqSqls.add(SqlMapping.get("adam_third_party.close"));
            objsThirdPart.add(new Object[]{now, uid});
        }

        /* ---------------------- 用户会员信息 */
        deleteResult = mongoTemplate.remove(Query.query(Criteria.where("uid").is(uid)), AdamUserMemberVo.class.getSimpleName());
        if (deleteResult.getDeletedCount() > 0) {
            toMqSqls.add(SqlMapping.get("adam_user_member.close"));
            objsThirdPart.add(new Object[]{now, uid});
        }

        /* ---------------------- 收货地址信息 */
        deleteResult = mongoTemplate.remove(Query.query(Criteria.where("uid").is(uid).and("state").is(1)), AdamAddressesVo.class.getSimpleName());
        if (deleteResult.getDeletedCount() > 0) {
            toMqSqls.add(SqlMapping.get("adam_addresses.close"));
            objsAddresses.add(new Object[]{now, now, uid});
        }

        /* ---------------------- 入场人信息 */
        deleteResult = mongoTemplate.remove(Query.query(Criteria.where("uid").is(uid)).getQueryObject(), AdamEnters.class.getSimpleName());
        if (deleteResult.getDeletedCount() > 0) {
            toMqSqls.add(SqlMapping.get("adam_enters.close"));
            objsAddresses.add(new Object[]{now, now, uid});
        }

        rabbitTemplate.convertAndSend(MQConst.EXCHANGES_LIQUIDNET_SQL, MQConst.ROUTING_KEY_SQL,
                SqlMapping.gets(toMqSqls, objsUser));
    }

    @Override
    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
    public AdamRealInfoVo identity(String uid, String name, String idCard) {
        // TODO: 2021/5/18 调用第三方认证服务

        AdamRealName realName = new AdamRealName();
        realName.setRealNameId(IDGenerator.nextSnowId() + "");
        realName.setUid(uid);
        realName.setType("1");
        realName.setName(name);
        realName.setIdCard(idCard);
        realName.setState(1);
        realName.setCreatedAt(LocalDateTime.now());
        adamRealNameService.add(realName);

        AdamRealInfoVo realInfoVo = AdamRealInfoVo.getNew();
        realInfoVo.setName(StringUtils.rightPad(StringUtils.left(name, 1), name.length(), "*"));
        realInfoVo.setIdCard(StringUtils.rightPad(StringUtils.left(idCard, 3), idCard.length(), "*").concat(StringUtils.right(idCard, 2)));
        realInfoVo.setState(1);

        adamRdmService.setRealInfoVoByUid(uid, realInfoVo);

        return realInfoVo;
    }
}
