package com.liquidnet.service.sweet.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 小程序登录记录用户解密后信息表
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-09-22
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class SweetAppletUser implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Long mid;

    /**
     * user_id
     */
    private String userId;

    /**
     * openId
     */
    @TableField("openId")
    private String openId;

    /**
     * unionId
     */
    @TableField("unionId")
    private String unionId;

    /**
     * 手机号
     */
    @TableField("getPhoneNumber")
    private String getPhoneNumber;

    /**
     * 手机号
     */
    @TableField("getPurePhoneNumber")
    private String getPurePhoneNumber;

    /**
     * 地区码
     */
    @TableField("getCountryCode")
    private String getCountryCode;

    /**
     * 1草莓 2五百里 3mdsk 4正在
     */
    private Integer type;

    /**
     * 创建时间
     */
    private LocalDateTime createdAt;

    /**
     * 更新时间
     */
    private LocalDateTime updatedAt;


}
