package com.liquidnet.service.stone.controller;

import com.github.pagehelper.PageInfo;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.stone.vo.StoneItemListVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.validation.Valid;
import java.util.List;

@Api(tags = "积分-订单相关")
@RestController
@RequestMapping("order")
@Validated
public class StoneOrderController {

    @GetMapping("pre")
    @ApiOperation("积分订单列表")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    public ResponseDto<PageInfo<List<StoneItemListVo>>> order(@RequestParam("page") @Valid Integer page) {
        return ResponseDto.success();
    }

    @GetMapping("list")
    @ApiOperation("积分订单列表")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    public ResponseDto<PageInfo<List<StoneItemListVo>>> orderList(@RequestParam("page") @Valid Integer page) {
        return ResponseDto.success();
    }

}
