package com.liquidnet.service.stone.controller;

import com.github.pagehelper.PageInfo;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.stone.dto.StoneScoreListDto;
import com.liquidnet.service.stone.service.IStoneScoreLogsService;
import com.liquidnet.service.stone.service.IStoneScoreUserService;
import com.liquidnet.service.stone.vo.StoneLogsListVo;
import com.liquidnet.service.stone.vo.StoneUserVo;
import io.swagger.annotations.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;


@Api(tags = "积分-用户相关")
@RestController
@RequestMapping("user")
@Validated
public class StoneUserController {

    @Autowired
    IStoneScoreUserService stoneScoreUserService;
    @Autowired
    IStoneScoreLogsService stoneScoreLogsService;

    @GetMapping("info")
    @ApiOperation("用户信息")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    public ResponseDto<StoneScoreListDto> stoneUserInfo() {
        return ResponseDto.success(stoneScoreUserService.stoneUserInfo());
    }

    @GetMapping("task")
    @ApiOperation("做任务")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "Integer", name = "taskId", value = "任务ID[0-每日任务|1-每日任务：购买演出|2-每日任务：购买商品|3-每日任务：划卡|4-一次性任务：关注公众号|5-一次性任务：完善信息|6-一次性任务：完善头像|7-一次性任务：打开消息推送|8-一次性任务：体验在场]", example = ""),
    })
    public ResponseDto<String> task(@RequestParam(value = "taskId", required = true) Integer taskId) {
        return stoneScoreLogsService.doTask(taskId);
    }

    @GetMapping("logs/list")
    @ApiOperation("积分详情列表")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "Integer", name = "page", value = "页数", example = ""),
    })
    public ResponseDto<PageInfo<List<StoneLogsListVo>>> logList(@RequestParam(value = "page", required = true) Integer page) {
        return ResponseDto.success(stoneScoreLogsService.logList(page));
    }

    @GetMapping("logs/in2111")
    @ApiOperation("增加积分")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "uid", value = "用户Id", example = ""),
            @ApiImplicitParam(type = "form", required = true, dataType = "Integer", name = "score", value = "积分", example = ""),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "content", value = "内容", example = ""),
    })
    public ResponseDto<String> inScore(@RequestParam(value = "uid", required = true) String uid,
                                       @RequestParam(value = "score", required = true) Integer score,
                                       @RequestParam(value = "content", required = true) String content) {
        return ResponseDto.success(stoneScoreLogsService.inScore(uid,score,2111,content));
    }

    @GetMapping("logs/de2111")
    @ApiOperation("减少积分")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "uid", value = "用户Id", example = ""),
            @ApiImplicitParam(type = "form", required = true, dataType = "Integer", name = "score", value = "积分", example = ""),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "content", value = "内容", example = ""),
    })
    public ResponseDto<String> deScore(@RequestParam(value = "uid", required = true) String uid,
                                       @RequestParam(value = "score", required = true) Integer score,
                                       @RequestParam(value = "content", required = true) String content) {
        return ResponseDto.success(stoneScoreLogsService.deScore(uid,score,2111,content));
    }

    @GetMapping("task/detail")
    @ApiOperation("用户任务详情")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    public ResponseDto<StoneUserVo> taskDetail() {
        return stoneScoreLogsService.taskDetail();
    }
}
