package com.liquidnet.service.kylin.dto.param;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.time.LocalDateTime;

@Data
public class PerformancePartnerListParam {
    @ApiModelProperty(value = "演出名称", example = "")
    private String title;
    @ApiModelProperty(value = "-2全部(不包括未提交)0未发布演出列表;3审核通过;6上线;7下架;8已结束;", example = "0")
    @NotNull(message = "不能为空")
    private int status;
    @ApiModelProperty(value = "-2全部,-1未提交审核，0审核中，1审核通过，2审核拒绝", example = "0")
    @NotNull(message = "不能为空")
    private int auditStatus;
    @ApiModelProperty(value = "演出开始时间", example = "2000-01-01 12:00:00")
    private String timeStart;
    @ApiModelProperty(value = "演出结束时间", example = "2000-01-01 12:00:00")
    private String timeEnd;
    @ApiModelProperty(value = "排序类型 1创建时间倒序 2创建时间正序 3演出时间倒序 4演出时间正序", example = "0")
    @NotNull(message = "不能为空")
    private int orderType;
    @ApiModelProperty(value = "停售时间(单位天)", example = "-1全部")
    private Long stopSellDay;
    @ApiModelProperty(value = "停售时间(单位天 -1全部", example = "-1", hidden = true)
    private LocalDateTime stopSellTime;
    @ApiModelProperty(value = "页数", example = "0")
    @NotNull(message = "不能为空")
    private int page;
    @ApiModelProperty(value = "数量", example = "20")
    @NotNull(message = "不能为空")
    private int size;
    @ApiModelProperty(value = "排序字段", hidden = true)
    private String orderItem;
    @ApiModelProperty(value = "排序方式", hidden = true)
    private String orderSc;

    public void setOrderType(int orderType) {
        this.orderType = orderType;
        switch (orderType) {
            case 1: {
                orderItem = "created_at";
                orderSc = "desc";
            }
            case 2: {
                orderItem = "created_at";
                orderSc = "asc";
            }
            case 3: {
                orderItem = "time_start";
                orderSc = "desc";
            }
            case 4: {
                orderItem = "time_start";
                orderSc = "asc";
            }

        }
    }

    public void setStopSellDay(Long stopSellDay) {
        LocalDateTime now = LocalDateTime.now();
        this.stopSellTime = now.plusDays(-stopSellDay);
    }
}
