package com.liquidnet.client.admin.zhengzai.smile.dto;

import com.liquidnet.service.kylin.dao.report.KylinPerformancesDto;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @author TT
 */
@Data
public class ShowVo implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 演出id
     */
    @ApiModelProperty(value = "演出id")
    private String performancesId;

    /**
     * 演出名
     */
    @ApiModelProperty(value = "演出名")
    private String title;

    /**
     * 城市
     */
    @ApiModelProperty(value = "城市")
    private String cityName;

    /**
     * 总销售数量  -张   saleGeneral
     */
    @ApiModelProperty(value = "总销售数量")
    private BigDecimal open;

    /**
     * 总销售金额  totalSalePrice
     */
    @ApiModelProperty(value = "总销售金额")
    private BigDecimal totalSalePrice;

    /**
     * 总销售代理
     */
    @ApiModelProperty(value = "总销售代理人数")
    private Integer totalOutAgent;

    /**
     * 演出结束时间
     */
    @ApiModelProperty(value = "演出结束时间")
    private LocalDateTime timeEnd;

    /**
     * 演出结束时间
     */
    @ApiModelProperty(value = "演出开始时间")
    private LocalDateTime timeStart;

    @ApiModelProperty(value = "演出状态")
    private Integer showStatus;

    @ApiModelProperty(value = "演出状态")
    private String statusName;

    /**
     * 打款状态
     */
    @ApiModelProperty(value = "演出打款状态")
    private String status;

    /**
     * 上下架状态【0：上架，1：下架】
     */
    @ApiModelProperty(value = "演出打款状态")
    private int type;

    /**
     * 顺序
     */
    @ApiModelProperty(value = "演出排列顺序")
    private String comment;

    public void setShowStatus(Integer status) {
        this.showStatus = status;
        switch (status) {
            case 1:
                this.statusName = "审核中";
                break;
            case 3:
                this.statusName = "审核通过";
                break;
            case 4:
                this.statusName = "审核拒绝";
                break;
            case 6:
                this.statusName = "售卖中";
                break;
            case 7:
                this.statusName = "已下架";
                break;
            case 8:
                this.statusName = "售罄";
                break;
            case 9:
                this.statusName = "未开始";
                break;
            case 10:
                this.statusName = "已结束";
                break;
            default:
                this.statusName = "其他";
                break;
        }
    }


    private static final ShowVo obj = new ShowVo();

    public static ShowVo getNew() {
        try {
            return (ShowVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new ShowVo();
        }
    }

    public ShowVo copy(KylinPerformancesDto kylinPerformancesDto) {
        if (null == kylinPerformancesDto) return null;
        this.setTimeStart(kylinPerformancesDto.getTimeStart());
        this.setComment(kylinPerformancesDto.getComment());
        this.setTitle(kylinPerformancesDto.getTitle());
        this.setShowStatus(kylinPerformancesDto.getStatus());
        this.setCityName(kylinPerformancesDto.getCityName());
        this.setTotalSalePrice(kylinPerformancesDto.getTotalSalePrice());
        this.setOpen(kylinPerformancesDto.getOpen() == null ? BigDecimal.valueOf(0) : kylinPerformancesDto.getOpen());
        this.setPerformancesId(kylinPerformancesDto.getPerformancesId());
        this.setTimeEnd(kylinPerformancesDto.getTimeEnd());
        this.setType(kylinPerformancesDto.getType());
        return this;
    }
}
