package com.liquidnet.common.cache.redis.config;//package com.liquidnet.common.cache.redis.config;

import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;

import java.util.List;


/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: RedisConfig
 * @Package com.liquidnet.common.cache.redis.config
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2021/8/10 16:28
 */
@Slf4j
@Configuration
public class RedisAdamConfig extends AbstractRedisConfig {

    @Value("${spring.redis.adam.host:null}")
    private String host;
    @Value("${spring.redis.adam.port:-1}")
    private int port;
    @Value("${spring.redis.adam.password:null}")
    private String password;
    @Value("${spring.redis.adam.lettuce.pool.max-active:-1}")
    private int maxActive;
    @Value("${spring.redis.adam.lettuce.pool.max-idle:-1}")
    private int maxIdle;
    @Value("${spring.redis.adam.lettuce.pool.min-idle:-1}")
    private int minIdle;
    @Value("${spring.redis.adam.lettuce.pool.max-wait:-1}")
    private int maxWait;

    @Value("${spring.redis.adam.dbs:${spring.redis.adam.database:-1}}")
    private List<Integer> dbs;

    String getHost(){
        return this.host;
    }

    int getPort(){
        return this.port;
    }
    String getPassword(){
        return this.password;
    }
    int getMaxActive(){
        return this.maxActive;
    }
    int getMaxIdle(){
        return this.maxIdle;
    }
    int getMinIdle(){
        return this.minIdle;
    }
    int getMaxWait(){
        return this.maxWait;
    }
    List<Integer> getDbs(){
        return this.dbs;
    }
}